/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.ServerRegistrationID;
import org.jboss.portal.theme.impl.render.dynamic.DynaDecorationRenderer;
import org.jboss.portal.theme.impl.render.dynamic.DynaPortletRenderer;
import org.jboss.portal.theme.impl.render.dynamic.DynaRegionRenderer;
import org.jboss.portal.theme.impl.render.dynamic.DynaWindowRenderer;
import org.jboss.portal.theme.metadata.RendererSetMetaData;
import org.jboss.portal.theme.render.ObjectRenderer;
import org.jboss.portal.theme.render.renderer.DecorationRenderer;
import org.jboss.portal.theme.render.renderer.PortletRenderer;
import org.jboss.portal.theme.render.renderer.RegionRenderer;
import org.jboss.portal.theme.render.renderer.WindowRenderer;

public final class PortalRenderSet {
    private final RegionRenderer regionRenderer;
    private final WindowRenderer windowRenderer;
    private final PortletRenderer portletRenderer;
    private final DecorationRenderer decorationRenderer;
    private final MediaType mediaType;
    private final String appID;
    private final String name;
    private final ServerRegistrationID registrationId;
    private final boolean ajaxEnabled;

    public PortalRenderSet(String renderSetName, RuntimeContext runtimeContext, RendererSetMetaData rendererSetMD) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (runtimeContext == null) {
            throw new IllegalArgumentException("no valid container");
        }
        if (rendererSetMD == null) {
            throw new IllegalArgumentException("no valid set");
        }
        this.name = renderSetName;
        this.appID = runtimeContext.getAppId();
        this.registrationId = ServerRegistrationID.createID(ServerRegistrationID.TYPE_RENDERSET, new String[]{this.appID, this.name});
        this.mediaType = rendererSetMD.getMediaType();
        this.ajaxEnabled = rendererSetMD.isAjaxEnabled();
        if (this.ajaxEnabled) {
            this.regionRenderer = new DynaRegionRenderer((RegionRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getRegionRenderer()));
            this.windowRenderer = new DynaWindowRenderer((WindowRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getWindowRenderer()));
            this.portletRenderer = new DynaPortletRenderer((PortletRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getPortletRenderer()));
            this.decorationRenderer = new DynaDecorationRenderer((DecorationRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getDecorationRenderer()));
        } else {
            this.regionRenderer = (RegionRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getRegionRenderer());
            this.windowRenderer = (WindowRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getWindowRenderer());
            this.portletRenderer = (PortletRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getPortletRenderer());
            this.decorationRenderer = (DecorationRenderer)this.loadRenderer(runtimeContext.getClassLoader(), rendererSetMD.getDecorationRenderer());
        }
    }

    public ServerRegistrationID getRegistrationId() {
        return this.registrationId;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getAppId() {
        return this.appID;
    }

    public String getName() {
        return this.name;
    }

    public RegionRenderer getRegionRenderer() {
        return this.regionRenderer;
    }

    public WindowRenderer getWindowRenderer() {
        return this.windowRenderer;
    }

    public PortletRenderer getPortletRenderer() {
        return this.portletRenderer;
    }

    public DecorationRenderer getDecorationRenderer() {
        return this.decorationRenderer;
    }

    public boolean isAjaxEnabled() {
        return this.ajaxEnabled;
    }

    public String toString() {
        return "PortalRenderSet: " + this.getAppId() + "." + (this.getName() == null ? "<from layout>" : this.getName()) + ": " + this.getMediaType() + " [" + this.getRegionRenderer() + "][" + this.getWindowRenderer() + "][" + this.getDecorationRenderer() + "][" + this.getPortletRenderer() + "]";
    }

    private ObjectRenderer loadRenderer(ClassLoader loader, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return (ObjectRenderer)loader.loadClass(className).newInstance();
    }
}

