/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.netvibes.provider;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.jboss.portal.common.net.URLTools;
import org.jboss.portal.widget.AbstractWidgetProvider;
import org.jboss.portal.widget.ExpiringFutureTask;
import org.jboss.portal.widget.WidgetQuery;
import org.jboss.portal.widget.netvibes.directory.NetvibesWidgetCategory;
import org.jboss.portal.widget.netvibes.json.JSONArray;
import org.jboss.portal.widget.netvibes.json.JSONException;
import org.jboss.portal.widget.netvibes.json.JSONObject;
import org.jboss.portal.widget.netvibes.provider.NetvibesDirectoryQueryMapEntry;
import org.jboss.portal.widget.netvibes.provider.NetvibesWidgetMapEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetvibesProvider
extends AbstractWidgetProvider {
    private Collection<NetvibesWidgetCategory> categories;

    public Collection<NetvibesWidgetCategory> getCategories() {
        if (this.categories == null) {
            ArrayList<NetvibesWidgetCategory> list = new ArrayList<NetvibesWidgetCategory>();
            try {
                URL url = new URL("http://api.eco.netvibes.com/categories?format=json");
                byte[] bytes = URLTools.getContent((URL)url, (int)this.connectionTimeout, (int)this.connectionTimeout);
                JSONObject jsonResponse = new JSONObject(new String(bytes));
                JSONArray array = jsonResponse.getJSONArray("categories");
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    list.add(new NetvibesWidgetCategory(object.getString("id"), object.getString("label")));
                }
                this.categories = Collections.unmodifiableList(list);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return this.categories;
    }

    protected void addDirectoryResult(WidgetQuery query) {
        ExpiringFutureTask dt = new ExpiringFutureTask(this.queryExpiration, (Callable)new NetvibesDirectoryQueryMapEntry(query, this.connectionTimeout));
        ExpiringFutureTask e = this.queries.putIfAbsent(query, dt);
        if (e == null) {
            e = dt;
            this.executor.submit((Runnable)e);
        }
    }

    protected void addWidget(URL url) {
        ExpiringFutureTask ft = new ExpiringFutureTask(this.entryExpiration, (Callable)new NetvibesWidgetMapEntry(url));
        ExpiringFutureTask e = this.entries.putIfAbsent(url, ft);
        if (e == null) {
            e = ft;
            this.executor.submit((Runnable)e);
        }
    }
}

