/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.info;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.portlet.TransportGuarantee;
import org.jboss.portal.portlet.info.SecurityInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerSecurityInfo
implements SecurityInfo {
    private final Set<TransportGuarantee> tgs;
    private final Set<TransportGuarantee> rotgs;
    private final Map<String, String> roleRefs;

    public ContainerSecurityInfo() {
        HashSet<TransportGuarantee> tgs = new HashSet<TransportGuarantee>();
        tgs.add(TransportGuarantee.NONE);
        this.tgs = tgs;
        this.roleRefs = new HashMap<String, String>();
        this.rotgs = Collections.unmodifiableSet(tgs);
    }

    public String getRoleRef(String roleName) {
        return this.roleRefs.get(roleName);
    }

    public boolean containsRoleRef(String roleName) {
        return this.roleRefs.containsKey(roleName);
    }

    public void addRoleRef(String roleName, String roleLink) {
        if (roleName == null) {
            throw new IllegalArgumentException();
        }
        this.roleRefs.put(roleName, roleLink);
    }

    public void addTransportGuarantee(TransportGuarantee transportGuarantee) {
        this.tgs.add(transportGuarantee);
    }

    @Override
    public boolean containsTransportGuarantee(TransportGuarantee transportGuarantee) {
        return this.tgs.contains((Object)transportGuarantee);
    }

    @Override
    public Set<TransportGuarantee> getTransportGuarantees() {
        return this.rotgs;
    }
}

