/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.impl.jsr168.api;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import javax.portlet.ResourceResponse;
import org.jboss.portal.common.net.media.ContentType;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.net.media.Parameter;
import org.jboss.portal.portlet.cache.CacheControl;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.portlet.impl.jsr168.api.MimeResponseImpl;
import org.jboss.portal.portlet.impl.jsr168.api.PortletRequestImpl;
import org.jboss.portal.portlet.invocation.ResourceInvocation;
import org.jboss.portal.portlet.invocation.response.ContentResponse;
import org.jboss.portal.portlet.invocation.response.ResponseProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceResponseImpl
extends MimeResponseImpl
implements ResourceResponse {
    private final CacheLevel cacheability;

    public ResourceResponseImpl(ResourceInvocation invocation, PortletRequestImpl preq) {
        super(invocation, preq);
        this.cacheability = invocation.getCacheLevel();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale cannot be null");
        }
        if ("".equals(locale.getCountry())) {
            this.addProperty("Content-Language", locale.getLanguage());
        } else {
            this.addProperty("Content-Language", locale.getLanguage() + "-" + locale.getCountry());
        }
    }

    public void setCharacterEncoding(String s) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        MediaType mediaType = null;
        String contentTypeString = this.getContentType();
        if (contentTypeString != null) {
            ContentType contentType = ContentType.create((String)contentTypeString);
            mediaType = contentType.getMediaType();
            for (Parameter parameter : contentType.getParameters()) {
                if (parameter.getName().trim().toLowerCase().equals("charset")) continue;
                parameters.add(parameter);
            }
        } else {
            mediaType = MediaType.TEXT_HTML;
        }
        parameters.add(new Parameter("charset", s));
        this.setContentType(new ContentType(mediaType, parameters).getValue());
    }

    public void setContentLength(int i) {
        this.addProperty("Content-Length", "" + i);
    }

    @Override
    public PortletURL createActionURL() {
        if (this.cacheability != CacheLevel.PAGE) {
            throw new IllegalStateException("Cannot create action URL because the current cache level " + (Object)((Object)this.cacheability) + " is not " + (Object)((Object)CacheLevel.PAGE));
        }
        return super.createActionURL();
    }

    @Override
    public PortletURL createRenderURL() {
        if (this.cacheability != CacheLevel.PAGE) {
            throw new IllegalStateException("Cannot create render URL because the current cache level " + (Object)((Object)this.cacheability) + " is not " + (Object)((Object)CacheLevel.PAGE));
        }
        return super.createRenderURL();
    }

    @Override
    protected ContentResponse createMarkupResponse(ResponseProperties properties, Map<String, Object> attributeMap, String contentType, byte[] bytes, String chars, CacheControl cacheControl) {
        return new ContentResponse(properties, attributeMap, contentType, bytes, chars, cacheControl);
    }
}

