/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.portlet.controller.impl.event;

import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.controller.event.EventControllerContext;
import org.jboss.portal.portlet.controller.event.EventPhaseContext;
import org.jboss.portal.portlet.controller.event.PortletWindowEvent;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;

public class EventControllerContextImpl
implements EventControllerContext {
    private PortletInvoker invoker;

    public EventControllerContextImpl(PortletInvoker invoker) {
        this.invoker = invoker;
    }

    public void eventProduced(EventPhaseContext context, PortletWindowEvent producedEvent, PortletWindowEvent sourceEvent) {
        try {
            for (Portlet portlet : this.invoker.getPortlets()) {
                PortletInfo portletInfo = portlet.getInfo();
                if (!portletInfo.getEventing().getConsumedEvents().containsKey(producedEvent.getName())) continue;
                PortletWindowEvent distributedEvent = new PortletWindowEvent(producedEvent.getName(), producedEvent.getPayload(), portlet.getContext().getId());
                context.queueEvent(distributedEvent);
            }
        }
        catch (PortletInvokerException e) {
            System.out.println("e = " + (Object)((Object)e));
            context.interrupt();
        }
    }

    public void eventConsumed(EventPhaseContext context, PortletWindowEvent consumedEvent, PortletInvocationResponse consumerResponse) {
    }

    public void eventFailed(EventPhaseContext context, PortletWindowEvent failedEvent, Throwable throwable) {
    }

    public void eventDiscarded(EventPhaseContext context, PortletWindowEvent discardedEvent, int cause) {
    }
}

