/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.widget.exceptions;

import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.widget.Widget;
import org.jboss.portal.widget.exceptions.WidgetException;
import org.jboss.portal.widget.exceptions.WidgetFetchException;
import org.jboss.portal.widget.exceptions.WidgetNotSupportedException;

public class WidgetFailure
implements Widget {
    private final URL url;
    private final Exception e;

    public WidgetFailure(URL url, Exception e) {
        this.url = url;
        this.e = e;
    }

    public String getMessage() {
        return this.e.getMessage();
    }

    public Throwable getCause() {
        return this.e.getCause();
    }

    public String getId() {
        return this.url.toString();
    }

    public String render(Map parameters) {
        return this.render(parameters, (Locale)null);
    }

    public String render(Map parameters, Locale locale) {
        return this.getLocalizedErrorMessage(locale);
    }

    public String getLocalizedErrorMessage(Locale locale) {
        String urlString = this.url != null ? this.url.toString() : null;
        Throwable cause = this.e.getCause();
        if (cause instanceof WidgetException) {
            if (cause instanceof WidgetNotSupportedException) {
                return "This widget type is not supported: " + urlString;
            }
            if (cause instanceof WidgetFetchException) {
                return "Failed to fetch Widget: " + urlString;
            }
            return "Error while retrieving Widget: " + urlString;
        }
        return "Error getting Widget: " + urlString;
    }

    public LocalizedString getDescription() {
        return null;
    }

    public LocalizedString getTitle() {
        return null;
    }
}

