/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.portal.core.admin.ui.AuthorizationBean;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.osivia.portal.core.page.PageProperties;

public abstract class MultiPortalsAuthorizationBean
extends AuthorizationBean {
    public String getManagedPortalName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set findPortalRoles() throws IdentityException {
        String savedPortal = null;
        try {
            String portalName = this.getManagedPortalName();
            if (portalName != null) {
                savedPortal = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
                PageProperties.getProperties().getPagePropertiesMap().put("portalName", portalName);
            }
            Set set = this.getRoleModule().findRoles();
            return set;
        }
        finally {
            if (savedPortal != null) {
                PageProperties.getProperties().getPagePropertiesMap().put("portalName", savedPortal);
            }
        }
    }

    @Override
    public String[] getRoles() {
        Set constraints;
        TreeSet<String> roleNames = new TreeSet<String>();
        String uri = this.getURI();
        if (uri != null && (constraints = this.getDomainConfigurator().getSecurityBindings(uri)) != null) {
            for (RoleSecurityBinding binding : constraints) {
                roleNames.add(binding.getRoleName());
            }
        }
        try {
            roleNames.add(SecurityConstants.UNCHECKED_ROLE_NAME);
            for (Role role : this.findPortalRoles()) {
                roleNames.add(role.getName());
            }
        }
        catch (IdentityException e) {
            e.printStackTrace();
        }
        return roleNames.toArray(new String[roleNames.size()]);
    }

    @Override
    public Map getRoleDisplayNameMap() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Role role : this.findPortalRoles()) {
                String displayName = role.getDisplayName();
                if (displayName == null) continue;
                String name = role.getName();
                map.put(name, displayName);
            }
            return map;
        }
        catch (IdentityException e) {
            return Collections.EMPTY_MAP;
        }
    }
}

