/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.coordination;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import javax.xml.namespace.QName;
import org.jboss.portal.core.admin.ui.coordination.CoordinationManagerBean;
import org.jboss.portal.core.controller.coordination.IllegalCoordinationException;
import org.jboss.portal.core.controller.coordination.ParameterBindingInfo;
import org.jboss.portal.core.controller.coordination.Utils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.portlet.info.NavigationInfo;
import org.jboss.portal.portlet.info.ParameterInfo;
import org.jboss.portal.portlet.info.PortletInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterBindingManagerBean
extends CoordinationManagerBean.CoordinationBean {
    private Map<String, DisplayParameterBinding> displayParameterBindings;
    private Map<Window, WindowSelectItemGroup> availableParameterWindowPairs;
    private List<String> selectedParameterWindowPairs;
    private String windowBindingName;
    private static final Comparator<SelectItem> COMP = new ParameterWindowSelectItemComparator();

    public ParameterBindingManagerBean() {
    }

    public ParameterBindingManagerBean(CoordinationManagerBean managerBean) {
        super(managerBean);
    }

    public List<? extends SelectItem> getAvailableParameterWindowPairs() {
        if (this.availableParameterWindowPairs == null || this.availableParameterWindowPairs.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<WindowSelectItemGroup> result = new LinkedList<WindowSelectItemGroup>(this.availableParameterWindowPairs.values());
        Collections.sort(result);
        return result;
    }

    public List<String> getSelectedParameterWindowPairs() {
        return this.selectedParameterWindowPairs;
    }

    public void setSelectedParameterWindowPairs(List<String> selectedParameterWindowPairs) {
        this.selectedParameterWindowPairs = selectedParameterWindowPairs;
    }

    public String getWindowBindingName() {
        return this.windowBindingName;
    }

    public void setWindowBindingName(String windowBindingName) {
        this.windowBindingName = windowBindingName;
    }

    @Override
    public void extractInfoFrom(Window window, PortletInfo info) {
        NavigationInfo navInfo = info.getNavigation();
        Collection publicParameters = navInfo.getPublicParameters();
        if (!publicParameters.isEmpty()) {
            WindowSelectItemGroup windowGroup = this.availableParameterWindowPairs.get(window);
            if (windowGroup == null) {
                windowGroup = new WindowSelectItemGroup(window);
                this.availableParameterWindowPairs.put(window, windowGroup);
            }
            for (ParameterInfo pInfo : publicParameters) {
                windowGroup.add(new ParameterWindowSelectItem(pInfo, window));
            }
        }
    }

    public Collection<DisplayParameterBinding> getDisplayParameterBindings() {
        if (this.displayParameterBindings == null || this.displayParameterBindings.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<DisplayParameterBinding> result = new LinkedList<DisplayParameterBinding>(this.displayParameterBindings.values());
        Collections.sort(result);
        return result;
    }

    @Override
    public void initKnowing(Collection<PortalObject> children) {
        this.availableParameterWindowPairs = new HashMap<Window, WindowSelectItemGroup>(children.size());
    }

    @Override
    public boolean loadInfoFrom(Page page) {
        Collection windowBindingInfos = this.managerBean.getCoordinationService().getParameterBindings(page);
        if (windowBindingInfos != null && !windowBindingInfos.isEmpty()) {
            this.displayParameterBindings = new HashMap<String, DisplayParameterBinding>(windowBindingInfos.size());
            for (ParameterBindingInfo wbInfo : windowBindingInfos) {
                this.displayParameterBindings.put(wbInfo.getName(), new DisplayParameterBinding(wbInfo));
            }
            return true;
        }
        this.displayParameterBindings = Collections.emptyMap();
        return false;
    }

    @Override
    protected void internalRename(String oldName, String newName) throws IllegalCoordinationException {
        this.managerBean.getCoordinationService().renameParameterBinding(this.managerBean.getSelectedPage(), oldName, newName);
    }

    @Override
    protected void internalCreate() throws IllegalCoordinationException {
        if (this.windowBindingName != null) {
            HashMap windowBinding = new HashMap();
            for (String pairAsString : this.selectedParameterWindowPairs) {
                String[] names = ParameterWindowPair.resolveFrom(pairAsString);
                Window window = (Window)this.managerBean.getSelectedPage().getChild(names[1]);
                Utils.addToMultiMap(windowBinding, (Object)window, (Object)QName.valueOf(names[0]));
            }
            this.managerBean.getCoordinationService().setParameterBinding(this.windowBindingName, windowBinding);
        }
    }

    @Override
    protected String getBeanName() {
        return this.windowBindingName;
    }

    @Override
    public String resetSelection() {
        this.windowBindingName = null;
        this.selectedParameterWindowPairs = null;
        return super.resetSelection();
    }

    @Override
    public String delete(String name) throws IllegalCoordinationException {
        this.managerBean.getCoordinationService().removeParameterBinding(this.managerBean.getSelectedPage(), name);
        return this.resetSelection();
    }

    public void selectParameterWindowPair(ValueChangeEvent event) {
        List oldValues = (List)event.getOldValue();
        List newValues = (List)event.getNewValue();
    }

    @Override
    public String getObjectTypeName() {
        return "COORDINATION_PARAMETER";
    }

    @Override
    public String getObjectNameForMessages() {
        return "binding";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.displayParameterBindings.containsKey(objectName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParameterWindowSelectItemComparator
    implements Comparator<SelectItem> {
        ParameterWindowSelectItemComparator() {
        }

        @Override
        public int compare(SelectItem o1, SelectItem o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    }

    public class WindowSelectItemGroup
    extends SelectItemGroup
    implements Comparable {
        public WindowSelectItemGroup(Window window) {
            super(window.getName());
        }

        public int compareTo(Object o) {
            SelectItem group = (SelectItem)o;
            return this.getLabel().compareTo(group.getLabel());
        }

        public void add(ParameterWindowSelectItem parameterWindowSelectItem) {
            SelectItem[] existing = this.getSelectItems();
            if (existing == null) {
                this.setSelectItems(new SelectItem[]{parameterWindowSelectItem});
            } else {
                ArrayList<SelectItem> items = new ArrayList<SelectItem>(Arrays.asList(existing));
                items.add(parameterWindowSelectItem);
                Collections.sort(items, COMP);
                this.setSelectItems(items.toArray(new SelectItem[items.size()]));
            }
        }
    }

    public static class ParameterWindowPair {
        private Window window;
        private QName name;
        public static final int PARAM_NAME = 0;
        public static final int WINDOW_NAME = 1;
        private static final String SEP = " &hArr; ";

        public ParameterWindowPair(ParameterInfo info, Window window) {
            this(info.getName(), window);
        }

        public ParameterWindowPair(QName name, Window window) {
            this.window = window;
            this.name = name;
        }

        public QName getName() {
            return this.name;
        }

        public Window getWindow() {
            return this.window;
        }

        public String getSeparator() {
            return SEP;
        }

        public String toString() {
            return ParameterWindowPair.asString(this.name, this.window);
        }

        static String asString(QName qname, Window window) {
            return qname + SEP + window.getName();
        }

        public static String[] resolveFrom(String pairAsString) {
            int separatorIndex = pairAsString.indexOf(SEP);
            String name = pairAsString.substring(0, separatorIndex);
            String windowName = pairAsString.substring(separatorIndex + SEP.length());
            return new String[]{name, windowName};
        }
    }

    public static class ParameterWindowSelectItem
    extends SelectItem
    implements Comparable {
        public ParameterWindowSelectItem(ParameterInfo parameterInfo, Window window) {
            super((Object)new ParameterWindowPair(parameterInfo, window), parameterInfo.getName().toString());
        }

        public int compareTo(Object o) {
            ParameterWindowSelectItem pair = (ParameterWindowSelectItem)o;
            return this.toString().compareTo(pair.toString());
        }

        private ParameterWindowPair getPair() {
            return (ParameterWindowPair)this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DisplayParameterBinding
    implements Comparable {
        private List<ParameterWindowPair> parameterWindowPairs;
        private ParameterBindingInfo bindingInfo;

        public DisplayParameterBinding(ParameterBindingInfo bindingInfo) {
            this.bindingInfo = bindingInfo;
            Set entries = bindingInfo.getMappings().entrySet();
            this.parameterWindowPairs = new LinkedList<ParameterWindowPair>();
            for (Map.Entry entry : entries) {
                Window window = (Window)entry.getKey();
                for (QName qName : (Set)entry.getValue()) {
                    this.parameterWindowPairs.add(new ParameterWindowPair(qName, window));
                }
            }
        }

        public String getName() {
            return this.bindingInfo.getName();
        }

        public ParameterBindingInfo getBindingInfo() {
            return this.bindingInfo;
        }

        public List<ParameterWindowPair> getParameterWindowPairs() {
            return this.parameterWindowPairs;
        }

        public int compareTo(Object o) {
            DisplayParameterBinding other = (DisplayParameterBinding)o;
            return this.getName().compareTo(other.getName());
        }
    }
}

