/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.faces.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.portlet.PortletContext;
import org.jboss.portal.common.i18n.LocaleManager;
import org.jboss.portal.core.identity.ui.UserPortletConstants;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.ThemeInfo;
import org.jboss.portal.theme.ThemeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticValues {
    public static List<SelectItem> getTimezone() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (int i = 0; i < UserPortletConstants.TIME_ZONE_OFFSETS.length; ++i) {
            if (UserPortletConstants.TIME_ZONE_OFFSETS[i] == null) continue;
            list.add(new SelectItem((Object)("" + i), UserPortletConstants.TIME_ZONE_OFFSETS[i]));
        }
        return list;
    }

    public static List<SelectItem> getTheme(FacesContext ctx) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        PortletContext pctx = (PortletContext)ctx.getExternalContext().getContext();
        ThemeService themeService = (ThemeService)pctx.getAttribute("ThemeService");
        for (PortalTheme theme : themeService.getThemes()) {
            ThemeInfo info = theme.getThemeInfo();
            list.add(new SelectItem((Object)info.getRegistrationId().toString(), info.getAppId() + "." + info.getName()));
        }
        return list;
    }

    public static List<SelectItem> getLocale(FacesContext ctx) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        Locale currentLocale = ctx.getViewRoot().getLocale();
        ArrayList locales = new ArrayList(LocaleManager.getLocales());
        Collections.sort(locales, new LocaleComparator());
        for (Locale locale : locales) {
            list.add(new SelectItem((Object)locale.toString(), locale.getDisplayName(currentLocale)));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleComparator
    implements Comparator<Locale> {
        private LocaleComparator() {
        }

        @Override
        public int compare(Locale arg0, Locale arg1) {
            Locale locale1 = arg0;
            Locale locale2 = arg1;
            int compare = locale1.getDisplayLanguage().compareTo(locale2.getDisplayLanguage());
            if (compare == 0) {
                compare = locale1.getDisplayCountry().compareTo(locale2.getDisplayCountry());
            }
            return compare;
        }
    }
}

