/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.ldap;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityContext;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.ServiceJNDIBinder;
import org.jboss.portal.identity.service.IdentityModuleService;

public class LDAPConnectionContext {
    private static final Logger log = Logger.getLogger(IdentityModuleService.class);
    public static final String CONNECTION_POOL = "com.sun.jndi.ldap.connect.pool";
    public static final String CONNECTION_POOL_DEBUG = "com.sun.jndi.ldap.connect.pool.debug";
    public static final String CONNECTION_POOL_INITSIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    public static final String CONNECTION_POOL_MAXSIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    public static final String CONNECTION_POOL_PREFSIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    public static final String CONNECTION_POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    public static final String CONNECTION_POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";
    private boolean pooling;
    private String poolingDebug;
    private String poolingInitsize;
    private String poolingMaxsize;
    private String poolingPrefsize;
    private String poolingProtocol;
    private String poolingTimeout;
    private String jndiName;
    private ServiceJNDIBinder jndiBinder;
    private String name;
    private String contextFactory;
    private String adminDN;
    private String adminPassword;
    private String protocol;
    private String authentication = "simple";
    private String host;
    private String port;
    private String externalContextJndiName;
    private IdentityContext identityContext;

    public Hashtable getEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this.getContextFactory());
        env.put("java.naming.provider.url", "ldap://" + this.getHost() + ":" + this.getPort());
        env.put("java.naming.security.authentication", this.getAuthentication());
        if (this.getAdminDN() != null) {
            env.put("java.naming.security.principal", this.getAdminDN());
        }
        if (this.getAdminPassword() != null) {
            env.put("java.naming.security.credentials", this.getAdminPassword());
        }
        if (this.getProtocol() != null) {
            env.put("java.naming.security.protocol", this.getProtocol());
        }
        if (this.isPooling()) {
            env.put(CONNECTION_POOL, "true");
            if (this.getPoolingDebug() != null) {
                System.setProperty(CONNECTION_POOL_DEBUG, this.getPoolingDebug());
            }
            if (this.getPoolingInitsize() != null) {
                System.setProperty(CONNECTION_POOL_INITSIZE, this.getPoolingInitsize());
            }
            if (this.getPoolingMaxsize() != null) {
                System.setProperty(CONNECTION_POOL_MAXSIZE, this.getPoolingMaxsize());
            }
            if (this.getPoolingPrefsize() != null) {
                System.setProperty(CONNECTION_POOL_PREFSIZE, this.getPoolingPrefsize());
            }
            if (this.getPoolingProtocol() != null) {
                System.setProperty(CONNECTION_POOL_PROTOCOL, this.getPoolingProtocol());
            } else {
                System.setProperty(CONNECTION_POOL_PROTOCOL, "plain ssl");
            }
            if (this.getPoolingTimeout() != null) {
                System.setProperty(CONNECTION_POOL_TIMEOUT, this.getPoolingTimeout());
            }
        }
        return env;
    }

    public LdapContext createInitialContext() throws IdentityException {
        try {
            if (this.getExternalContextJndiName() != null) {
                InitialContext iniCtx = new InitialContext();
                return (LdapContext)iniCtx.lookup(this.getExternalContextJndiName());
            }
            Hashtable env = this.getEnvironment();
            return new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            throw new IdentityException("Unable to connect to LDAP: " + this, e);
        }
    }

    public void start() throws Exception {
        if (this.jndiName != null && this.jndiBinder != null) {
            log.debug((Object)("Binding identity module to JNDI with name: " + this.jndiName));
            this.jndiBinder.bind(this.jndiName, this);
        }
        if (this.identityContext != null) {
            this.identityContext.register(this, "ConnectionContext");
        }
    }

    public void stop() throws Exception {
        if (this.jndiName != null && this.jndiBinder != null) {
            this.jndiBinder.unbind(this.jndiName);
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Name: ").append(this.getName()).append(", Host: ").append(this.getHost()).append(", Port: ").append(this.getPort()).append(", Context factory: ").append(this.getContextFactory()).append(", Admin user: ").append(this.getAdminDN()).append(", Admin password: ").append("***").append(", Authentication: ").append(this.getAuthentication()).append(", Protocol: ").append(this.getProtocol());
        return str.toString();
    }

    public String getAuthentication() {
        if (this.authentication == null) {
            return "simple";
        }
        return this.authentication;
    }

    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getAdminDN() {
        return this.adminDN;
    }

    public void setAdminDN(String adminDN) {
        this.adminDN = adminDN;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getExternalContextJndiName() {
        return this.externalContextJndiName;
    }

    public void setExternalContextJndiName(String externalContextJndiName) {
        this.externalContextJndiName = externalContextJndiName;
    }

    public ServiceJNDIBinder getJndiBinder() {
        return this.jndiBinder;
    }

    public void setJndiBinder(ServiceJNDIBinder jndiBinder) {
        this.jndiBinder = jndiBinder;
    }

    public IdentityContext getIdentityContext() {
        return this.identityContext;
    }

    public void setIdentityContext(IdentityContext identityContext) {
        this.identityContext = identityContext;
    }

    public boolean isPooling() {
        return this.pooling;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public String getPoolingDebug() {
        return this.poolingDebug;
    }

    public void setPoolingDebug(String poolingDebug) {
        this.poolingDebug = poolingDebug;
    }

    public String getPoolingInitsize() {
        return this.poolingInitsize;
    }

    public void setPoolingInitsize(String poolingInitsize) {
        this.poolingInitsize = poolingInitsize;
    }

    public String getPoolingMaxsize() {
        return this.poolingMaxsize;
    }

    public void setPoolingMaxsize(String poolingMaxsize) {
        this.poolingMaxsize = poolingMaxsize;
    }

    public String getPoolingPrefsize() {
        return this.poolingPrefsize;
    }

    public void setPoolingPrefsize(String poolingPrefsize) {
        this.poolingPrefsize = poolingPrefsize;
    }

    public String getPoolingProtocol() {
        return this.poolingProtocol;
    }

    public void setPoolingProtocol(String poolingProtocol) {
        this.poolingProtocol = poolingProtocol;
    }

    public String getPoolingTimeout() {
        return this.poolingTimeout;
    }

    public void setPoolingTimeout(String poolingTimeout) {
        this.poolingTimeout = poolingTimeout;
    }
}

