/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.service;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.metadata.config.ConfigOptionMetaData;
import org.jboss.portal.identity.metadata.config.IdentityMetadataProcessor;
import org.jboss.portal.identity.metadata.config.ModuleMetaData;
import org.jboss.portal.identity.metadata.config.ModulesMetaData;
import org.jboss.portal.identity.metadata.service.ModuleServiceMetaData;

public class ModuleServicesMetaData {
    private List modulesList = new LinkedList();
    private Logger logger = Logger.getLogger(ModuleServicesMetaData.class);

    public ModuleServicesMetaData(ModulesMetaData defaultModulesMetaData, ModulesMetaData modulesMetaData) throws Exception {
        HashMap defaultImplementations = new HashMap();
        try {
            List defaultModules = defaultModulesMetaData.getModules();
            for (ModuleMetaData module : defaultModules) {
                if (module.getType() == null || module.getImplementation() == null || module.getServiceName() == null || module.getConfig() == null) {
                    this.logger.error((Object)("Default module configuration isn't complete" + module));
                    throw new IdentityException("Default module configuration must be complete");
                }
                String implType = module.getImplementation();
                Map implementation = defaultImplementations.containsKey(implType) ? (Map)defaultImplementations.get(implType) : new HashMap();
                implementation.put(module.getType(), module);
                defaultImplementations.put(implType, implementation);
            }
        }
        catch (Exception e) {
            throw new IdentityException("Error during processing default configuration file", e);
        }
        for (ModuleMetaData module : modulesMetaData.getModules()) {
            IdentityMetadataProcessor.updateModuleWithDefaults(module, defaultImplementations);
            Map configOptions = module.getConfig().getOptions();
            HashMap<String, String> optionMap = new HashMap<String, String>();
            for (String optionName : configOptions.keySet()) {
                ConfigOptionMetaData option = (ConfigOptionMetaData)configOptions.get(optionName);
                optionMap.put(optionName, option.getValue());
            }
            if (module.getClassName() == null) {
                throw new IdentityException("No classname defined for module type: " + module.getType() + ". Wrong configuration.");
            }
            this.modulesList.add(new ModuleServiceMetaData(module, optionMap));
        }
    }

    public List getModulesList() {
        return this.modulesList;
    }
}

