/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.taglib.toutatice;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.taglib.common.ToutaticeSimpleTag;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.BooleanUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.IMenubarService;
import org.osivia.portal.api.menubar.MenubarContainer;
import org.osivia.portal.api.menubar.MenubarGroup;
import org.osivia.portal.api.menubar.MenubarItem;

public class AddMenubarItemTag
extends ToutaticeSimpleTag {
    private String id;
    private String labelKey;
    private Integer order;
    private String url;
    private String onclick;
    private String htmlClass;
    private String target;
    private String glyphicon;
    private Boolean ajax;
    private String dropdown;
    private Map<String, String> data;
    private final IMenubarService menubarService = (IMenubarService)Locator.findMBean(IMenubarService.class, (String)"osivia:service=MenubarService");
    private final IInternationalizationService internationalizationService = (IInternationalizationService)Locator.findMBean(IInternationalizationService.class, (String)"osivia:service=InternationalizationService");

    @Override
    protected void doTag(NuxeoController nuxeoController, DocumentDTO document) throws JspException, IOException {
        PageContext pageContext = (PageContext)this.getJspContext();
        ServletRequest servletRequest = pageContext.getRequest();
        PortletRequest portletRequest = nuxeoController.getRequest();
        List menubar = (List)servletRequest.getAttribute("osivia.menuBar");
        if (menubar != null) {
            String title;
            if (this.labelKey != null) {
                Locale locale = servletRequest.getLocale();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                ClassLoader customizedClassLoader = (ClassLoader)portletRequest.getAttribute("osivia.customizer.cms.jsp.classloader");
                title = this.internationalizationService.getString(this.labelKey, locale, classLoader, customizedClassLoader, new Object[0]);
            } else {
                title = null;
            }
            MenubarGroup parent = null;
            if (this.dropdown != null && nuxeoController != null) {
                PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
                parent = this.menubarService.getDropdown(portalControllerContext, this.dropdown);
            }
            if (parent == null) {
                parent = MenubarGroup.SPECIFIC;
            }
            int orderInt = this.order == null ? 0 : this.order;
            MenubarItem item = new MenubarItem(this.id, title, this.glyphicon, (MenubarContainer)parent, orderInt, this.url, this.target, this.onclick, this.htmlClass);
            item.setAjaxDisabled(BooleanUtils.isFalse((Boolean)this.ajax));
            if (this.data != null) {
                item.getData().putAll(this.data);
            }
            menubar.add(item);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabelKey(String labelKey) {
        this.labelKey = labelKey;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOnclick(String onclick) {
        this.onclick = onclick;
    }

    public void setHtmlClass(String htmlClass) {
        this.htmlClass = htmlClass;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setGlyphicon(String glyphicon) {
        this.glyphicon = glyphicon;
    }

    public void setAjax(Boolean ajax) {
        this.ajax = ajax;
    }

    public void setDropdown(String dropdown) {
        this.dropdown = dropdown;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }
}

