/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.i18n;

import java.io.IOException;
import java.util.Locale;
import java.util.NoSuchElementException;
import org.jboss.portal.common.i18n.LocaleFormat;
import org.jboss.portal.common.text.CharBuffer;
import org.jboss.portal.common.util.ConversionException;

public class BundleName {
    private final String baseName;
    private final Locale locale;

    public BundleName(String baseName) {
        this(baseName, "", "", "");
    }

    public BundleName(String baseName, String language) {
        this(baseName, language, "", "");
    }

    public BundleName(String baseName, String language, String country) {
        this(baseName, language, country, "");
    }

    public BundleName(String baseName, String language, String country, String variant) {
        if (baseName == null) {
            throw new IllegalArgumentException();
        }
        if (language == null) {
            throw new IllegalArgumentException();
        }
        if (country == null) {
            throw new IllegalArgumentException();
        }
        if (variant == null) {
            throw new IllegalArgumentException();
        }
        this.baseName = baseName;
        this.locale = new Locale(language, country, variant);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public String getCountry() {
        return this.locale.getCountry();
    }

    public String getVariant() {
        return this.locale.getVariant();
    }

    public String toString() {
        if (this.locale.getLanguage().length() == 0 && this.locale.getCountry().length() == 0) {
            return this.baseName;
        }
        CharBuffer buffer = new CharBuffer(this.baseName.length() + 15);
        buffer.append(this.baseName);
        buffer.append('_');
        try {
            LocaleFormat.DEFAULT.write(this.locale, buffer);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ConversionException e) {
            throw new AssertionError((Object)e);
        }
        return buffer.asString();
    }

    public static class Parser {
        public BundleName parse(String s, int from, int to) {
            if (s == null) {
                throw new IllegalArgumentException();
            }
            if (from < 0) {
                throw new IllegalArgumentException();
            }
            if (to < s.length()) {
                throw new IllegalArgumentException();
            }
            if (to < from) {
                throw new IllegalArgumentException();
            }
            int p1 = s.lastIndexOf(95, to - 1);
            if (p1 < from) {
                p1 = -1;
            }
            if (p1 == -1) {
                return new BundleName(s.substring(from, to));
            }
            if (p1 == to - 1) {
                return null;
            }
            String a = s.substring(p1 + 1, to);
            int p2 = s.lastIndexOf(95, p1 - 1);
            if (p2 < from) {
                p2 = -1;
            }
            if (p2 == -1) {
                return new BundleName(s.substring(from, p1), a);
            }
            String b = p2 == p1 - 1 ? "" : s.substring(p2 + 1, p1);
            int p3 = s.lastIndexOf(95, p2 - 1);
            if (p3 < from) {
                p3 = -1;
            }
            if (p3 == -1) {
                return new BundleName(s.substring(from, p2), b, a);
            }
            String c = p3 == p2 - 1 ? "" : s.substring(p3 + 1, p2);
            return new BundleName(s.substring(from, p3), c, b, a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Iterator
    implements java.util.Iterator<BundleName> {
        private BundleName name;
        private int status;

        public Iterator(String baseName, Locale locale) {
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            this.status = 8 + (language.length() > 0 ? 4 : 0) + (country.length() > 0 ? 2 : 0) + (variant.length() > 0 ? 1 : 0);
            switch (this.status & 7) {
                case 0: {
                    this.name = new BundleName(baseName);
                    break;
                }
                case 1: {
                    this.name = new BundleName(baseName, "", "", variant);
                    break;
                }
                case 2: {
                    this.name = new BundleName(baseName, "", variant, "");
                    break;
                }
                case 3: {
                    this.name = new BundleName(baseName, "", country, variant);
                    break;
                }
                case 4: {
                    this.name = new BundleName(baseName, language, "", "");
                    break;
                }
                case 5: {
                    this.name = new BundleName(baseName, language, "", variant);
                    break;
                }
                case 6: {
                    this.name = new BundleName(baseName, language, country, "");
                    break;
                }
                case 7: {
                    this.name = new BundleName(baseName, language, country, variant);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should not be here");
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.status != 0;
        }

        @Override
        public BundleName next() {
            if (this.status >= 8) {
                this.status -= 8;
            } else {
                switch (this.status) {
                    case 0: {
                        throw new NoSuchElementException();
                    }
                    case 1: {
                        this.name = new BundleName(this.name.getBaseName());
                        this.status = 0;
                        break;
                    }
                    case 2: {
                        this.name = new BundleName(this.name.getBaseName());
                        this.status = 0;
                        break;
                    }
                    case 3: {
                        this.name = new BundleName(this.name.getBaseName(), "", this.name.getCountry());
                        this.status = 2;
                        break;
                    }
                    case 4: {
                        this.name = new BundleName(this.name.getBaseName());
                        this.status = 0;
                        break;
                    }
                    case 5: {
                        this.name = new BundleName(this.name.getBaseName(), this.name.getLanguage());
                        this.status = 4;
                        break;
                    }
                    case 6: {
                        this.name = new BundleName(this.name.getBaseName(), this.name.getLanguage());
                        this.status = 4;
                        break;
                    }
                    case 7: {
                        this.name = new BundleName(this.name.getBaseName(), this.name.getLanguage(), this.name.getCountry());
                        this.status = 6;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Should not be here");
                    }
                }
            }
            return this.name;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

