/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.util.Collection;
import java.util.Iterator;

public class IteratorStatus
implements Iterator {
    private final Iterator delegate;
    private int index;

    public IteratorStatus(Iterator delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("No iterator is provided");
        }
        this.delegate = delegate;
        this.index = -1;
    }

    public IteratorStatus(Collection c) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("No collection is provided");
        }
        this.delegate = c.iterator();
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isFirst() throws IllegalStateException {
        if (this.index == -1) {
            throw new IllegalStateException("No element has been iterated so far");
        }
        return this.index == 0;
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        Object o = this.delegate.next();
        ++this.index;
        return o;
    }

    public void remove() {
        this.delegate.remove();
    }
}

