/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.ha;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ha.singleton.HASingletonSupport;
import org.jboss.invocation.Invocation;
import org.jboss.naming.Util;
import org.jboss.portal.jems.ha.HASingletonInvokerMBean;

public class HASingletonInvoker
extends HASingletonSupport
implements HASingletonInvokerMBean {
    private ObjectName proxyFactory;
    private HASingletonInvokerMBean.Proxy proxy;
    private String jndiName;
    private HASingletonInvokerMBean.Callback callback;
    private Properties jndiProperties;
    private int maxRetries;
    private long retryWaitingTimeMS;

    public long getRetryWaitingTimeMS() {
        return this.retryWaitingTimeMS;
    }

    public void setRetryWaitingTimeMS(long retryWaitingTimeMS) {
        this.retryWaitingTimeMS = retryWaitingTimeMS;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public Properties getJNDIProperties() {
        return this.jndiProperties;
    }

    public void setJNDIProperties(Properties jndiProperties) {
        this.jndiProperties = jndiProperties;
    }

    public ObjectName getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(ObjectName proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public HASingletonInvokerMBean.Callback getCallback() {
        return this.callback;
    }

    public void setCallback(HASingletonInvokerMBean.Callback callback) {
        this.callback = callback;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public HASingletonInvokerMBean.Proxy lookupProxy() {
        if (this.proxy == null) {
            try {
                InitialContext ctx = new InitialContext(this.jndiProperties);
                this.proxy = (HASingletonInvokerMBean.Proxy)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                this.log.error((Object)("Proxy " + this.jndiName + " not bound"));
            }
        }
        return this.proxy;
    }

    public Object invoke(String methodName, Class[] types, Object[] args) throws Exception {
        int retries = this.maxRetries;
        while (retries-- > 0) {
            try {
                HASingletonInvokerMBean.Proxy proxy = this.lookupProxy();
                return proxy.invoke(methodName, types, args);
            }
            catch (Throwable t) {
                if (!(t instanceof Error)) {
                    this.proxy = null;
                    if (retries > 0) {
                        this.log.error((Object)("Cannot invoke proxy will retry " + retries + " times"), t);
                        try {
                            this.log.debug((Object)("Sleeping for " + this.retryWaitingTimeMS + " before trying to fail over"));
                            Thread.sleep(this.retryWaitingTimeMS);
                        }
                        catch (InterruptedException ignore) {
                            retries = 0;
                        }
                        continue;
                    }
                    this.log.error((Object)"Cannot invoke proxy will no more retry", t);
                    continue;
                }
                throw (Error)t;
            }
        }
        return null;
    }

    protected void startService() throws Exception {
        this.callback.setInvoker(this);
        super.startService();
    }

    protected void stopService() throws Exception {
        super.stopService();
        this.callback.setInvoker(null);
    }

    public void startSingleton() {
        String name = this.callback.getDisplayName();
        try {
            this.log.debug((Object)("Starting singleton " + name));
            this.callback.startSingleton();
            this.log.debug((Object)("Singleton " + name + " started"));
            this.log.debug((Object)("Binding singleton proxy " + name));
            Object proxy = this.server.getAttribute(this.proxyFactory, "Proxy");
            Util.bind((Context)new InitialContext(), (String)this.jndiName, (Object)proxy);
            this.log.debug((Object)("Singleton proxy " + name + " bound"));
        }
        catch (Exception e) {
            this.log.error((Object)("Not able to start singleton " + name + " bound"), (Throwable)e);
        }
    }

    public void stopSingleton() {
        if (this.callback != null) {
            String name = this.callback.getDisplayName();
            this.log.debug((Object)("Stopping singleton proxy " + name));
            this.callback.stopSingleton();
            this.log.debug((Object)("Singleton " + name + " stopped"));
        }
    }

    public Object invoke(Invocation mi) throws Exception {
        Method m = mi.getMethod();
        Object[] args = mi.getArguments();
        return this.callback.invoke(m.getName(), m.getParameterTypes(), args);
    }
}

