/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.jems.hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.event.EventListeners;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.impl.SessionFactoryImpl;
import org.jboss.portal.jems.hibernate.ContextObject;

public class ObjectContextualizer {
    public Object context;

    public ObjectContextualizer(Object context) {
        this.context = context;
    }

    public void attach(SessionFactory sessionFactory) {
        EventListeners listeners = ((SessionFactoryImpl)sessionFactory).getEventListeners();
        PostLoadEventListener[] lels1 = listeners.getPostLoadEventListeners();
        PostLoadEventListener[] lels2 = new PostLoadEventListener[lels1.length + 1];
        System.arraycopy(lels1, 0, lels2, 1, lels1.length);
        lels2[0] = new PostLoadEventListener(){

            public void onPostLoad(PostLoadEvent postLoadEvent) {
                Object entity = postLoadEvent.getEntity();
                if (entity instanceof ContextObject) {
                    ContextObject object = (ContextObject)entity;
                    object.setContext(ObjectContextualizer.this.context);
                }
            }
        };
        listeners.setPostLoadEventListeners(lels2);
    }
}

