/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.management.Notification;
import javax.management.NotificationFilter;
import org.jboss.util.CollectionsFactory;

public class JBossNotificationFilterSupport
implements NotificationFilter,
Serializable {
    private static final long serialVersionUID = 6442164418782871672L;
    private List enabledTypes = CollectionsFactory.createCopyOnWriteList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAllTypes() {
        JBossNotificationFilterSupport jBossNotificationFilterSupport = this;
        synchronized (jBossNotificationFilterSupport) {
            this.enabledTypes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableType(String type) {
        JBossNotificationFilterSupport jBossNotificationFilterSupport = this;
        synchronized (jBossNotificationFilterSupport) {
            this.enabledTypes.remove(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableType(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("null notification type");
        }
        JBossNotificationFilterSupport jBossNotificationFilterSupport = this;
        synchronized (jBossNotificationFilterSupport) {
            if (!this.enabledTypes.contains(type)) {
                this.enabledTypes.add(type);
            }
        }
    }

    public Vector getEnabledTypes() {
        return new Vector(this.enabledTypes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getName()).append(':');
        sb.append(" enabledTypes=").append(this.getEnabledTypes());
        return sb.toString();
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("null notification");
        }
        String notificationType = notification.getType();
        for (String type : this.enabledTypes) {
            if (!notificationType.startsWith(type)) continue;
            return true;
        }
        return false;
    }
}

