/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller.portlet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import org.apache.log4j.Logger;
import org.jboss.portal.Mode;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.portlet.ControllerStateControllerContext;
import org.jboss.portal.core.controller.portlet.CoreEventControllerContext;
import org.jboss.portal.core.controller.portlet.PortletInvocationFactory;
import org.jboss.portal.core.impl.model.content.InternalContentProviderRegistry;
import org.jboss.portal.core.impl.model.content.portlet.PortletContent;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.identity.User;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.event.EventControllerContext;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.EventInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.ResourceInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.PortletInvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerPortletControllerContext
implements PortletControllerContext {
    private static final Logger log = Logger.getLogger(ControllerPortletControllerContext.class);
    private final ControllerContext controllerContext;
    private final Map<String, PortletInfo> infos;
    private final Map<String, Window> windows;
    private final Map<String, Instance> instances;
    private final ControllerStateControllerContext stateControllerContext;
    private final CoreEventControllerContext eventControllerContext;
    private final String pageId;
    private final Page page;

    public ControllerPortletControllerContext(ControllerContext controllerContext, Page page) {
        InstanceContainer instanceContainer = controllerContext.getController().getInstanceContainer();
        HashMap<String, PortletInfo> infos = new HashMap<String, PortletInfo>();
        HashMap<String, Instance> instances = new HashMap<String, Instance>();
        HashMap<String, Window> windows = new HashMap<String, Window>();
        for (PortalObject child : page.getChildren(8)) {
            String instanceId;
            Window window = (Window)child;
            Content content = window.getContent();
            if (content instanceof PortletContent) {
                PortletContent portletContent = (PortletContent)content;
                instanceId = portletContent.getInstanceRef();
            } else {
                ContentType contentType;
                InternalContentProviderRegistry registry = controllerContext.getController().getContentProviderRegistry();
                ContentProvider provider = registry.getContentProvider(contentType = window.getContentType());
                if (provider != null) {
                    instanceId = provider.getPortletInfo().getPortletName(Mode.VIEW);
                } else {
                    log.debug((Object)("Couldn't find a ContentProvider for content type '" + contentType + "'"));
                    instanceId = null;
                }
            }
            if (instanceId != null) {
                InstanceDefinition instance = instanceContainer.getDefinition(instanceId);
                if (instance == null) continue;
                try {
                    Portlet portlet = instance.getPortlet();
                    infos.put(window.getName(), portlet.getInfo());
                    instances.put(window.getName(), instance);
                    windows.put(window.getName(), window);
                }
                catch (PortletInvokerException ignore) {
                    log.debug((Object)("Couldn't get portlet from instance '" + instance + "'"), (Throwable)ignore);
                }
                continue;
            }
            log.debug((Object)("Couldn't resolve instance id for window '" + window.getName() + "'"));
        }
        NavigationalStateContext nsContext = (NavigationalStateContext)controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
        this.stateControllerContext = new ControllerStateControllerContext(nsContext, this);
        this.eventControllerContext = new CoreEventControllerContext(this);
        this.controllerContext = controllerContext;
        this.windows = windows;
        this.infos = infos;
        this.instances = instances;
        this.pageId = page.getId().toString();
        this.page = page;
    }

    public Page getPage() {
        return this.page;
    }

    public String getPageId() {
        return this.pageId;
    }

    public Window getWindow(String windowName) {
        return this.windows.get(windowName);
    }

    public Set<String> getWindowNames() {
        return this.windows.keySet();
    }

    public PortletInfo getPortletInfo(String windowName) {
        return this.infos.get(windowName);
    }

    public PortletInvocationContext createPortletInvocationContext(String s, PortletPageNavigationalState pageNavigationalState) {
        Window window = this.windows.get(s);
        return PortletInvocationFactory.createInvocationContext(this.controllerContext, window, pageNavigationalState);
    }

    public PortletInvocationResponse invoke(ActionInvocation actionInvocation) throws PortletInvokerException {
        return this.internalInvoke((PortletInvocation)actionInvocation);
    }

    public PortletInvocationResponse invoke(List<Cookie> cookies, EventInvocation eventInvocation) throws PortletInvokerException {
        return this.internalInvoke((PortletInvocation)eventInvocation);
    }

    public PortletInvocationResponse invoke(List<Cookie> cookies, RenderInvocation renderInvocation) throws PortletInvokerException {
        return this.internalInvoke((PortletInvocation)renderInvocation);
    }

    public PortletInvocationResponse invoke(ResourceInvocation resourceInvocation) throws PortletInvokerException {
        return this.internalInvoke((PortletInvocation)resourceInvocation);
    }

    public EventControllerContext getEventControllerContext() {
        return this.eventControllerContext;
    }

    public ControllerStateControllerContext getStateControllerContext() {
        return this.stateControllerContext;
    }

    private PortletInvocationResponse internalInvoke(PortletInvocation actionInvocation) throws PortletInvokerException {
        PortletInvocationFactory.contextualize(actionInvocation);
        Window window = PortletInvocationFactory.getTargetWindow(actionInvocation);
        User user = this.controllerContext.getUser();
        CustomizationManager customizationManager = this.controllerContext.getController().getCustomizationManager();
        Instance instance = customizationManager.getInstance(window, user);
        return instance.invoke(actionInvocation);
    }

    public ControllerContext getControllerContext() {
        return this.controllerContext;
    }
}

