/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.impl.api.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.portal.api.PortalRuntimeContext;
import org.jboss.portal.api.node.PortalNode;
import org.jboss.portal.api.node.PortalNodeURL;
import org.jboss.portal.common.i18n.LocalizedString;
import org.jboss.portal.common.i18n.ResourceBundleFactory;
import org.jboss.portal.common.i18n.ResourceBundleManager;
import org.jboss.portal.common.i18n.SimpleResourceBundleFactory;
import org.jboss.portal.common.path.RelativePathParser;
import org.jboss.portal.core.impl.api.PortalRuntimeContextImpl;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPermission;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;

public class PortalNodeImpl
implements PortalNode {
    private static final String ORDER = "order";
    private static final String RESOURCE_PREFIX = "PAGENAME_";
    private static final String BUNDLE_BASE_NAME = "conf.bundles.Resource";
    private static final ResourceBundleManager resourceBundles = new ResourceBundleManager(null, (ResourceBundleFactory)new SimpleResourceBundleFactory("conf.bundles.Resource", PortalNodeImpl.class.getClassLoader()));
    final PortalObject object;
    private PortalNodeImpl parentNode;
    private final NodeList children;
    private PortalNode root;
    private String displayNameKey;
    private final PortalAuthorizationManager portalAuthorizationManager;
    private static final Comparator siblingComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            float weight2;
            PortalNodeImpl node1 = (PortalNodeImpl)o1;
            PortalNodeImpl node2 = (PortalNodeImpl)o2;
            float weight1 = node1.getWeight();
            if (weight1 == (weight2 = node2.getWeight())) {
                if (2 == node1.getType()) {
                    String orderProperty1S = (String)node1.getProperties().get(PortalNodeImpl.ORDER);
                    String orderProperty2S = (String)node2.getProperties().get(PortalNodeImpl.ORDER);
                    if (orderProperty1S != null && orderProperty2S == null) {
                        return -1;
                    }
                    if (orderProperty1S == null && orderProperty2S != null) {
                        return 1;
                    }
                    if (orderProperty1S != null && orderProperty2S != null) {
                        float orderProperty1 = -1.0f;
                        float orderProperty2 = -1.0f;
                        try {
                            orderProperty1 = Float.parseFloat(orderProperty1S);
                            orderProperty2 = Float.parseFloat(orderProperty2S);
                            if (orderProperty1 > orderProperty2) {
                                return 1;
                            }
                            if (orderProperty1 < orderProperty2) {
                                return -1;
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                }
                return node1.getName().compareTo(node2.getName());
            }
            if (weight1 < weight2) {
                return -1;
            }
            return 1;
        }
    };

    public PortalNodeImpl(PortalAuthorizationManager portalAuthorizationManager, PortalObject object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.portalAuthorizationManager = portalAuthorizationManager;
        this.object = object;
        this.children = new Children(this);
    }

    private PortalNodeImpl(PortalNodeImpl parentNode, PortalObject object) {
        this.portalAuthorizationManager = parentNode.portalAuthorizationManager;
        this.parentNode = parentNode;
        this.object = object;
        this.children = new Children(this);
    }

    private PortalNodeImpl(PortalObject object, PortalNodeImpl childNode) {
        this.portalAuthorizationManager = childNode.portalAuthorizationManager;
        this.object = object;
        this.children = new Siblings(childNode);
    }

    public int getType() {
        return this.object.getType();
    }

    public PortalNode getRoot() {
        if (this.root == null) {
            PortalNode parent = this.getParent();
            this.root = parent == null ? this : parent.getRoot();
        }
        return this.root;
    }

    public PortalNode getParent() {
        PortalObject objectParent;
        if (this.parentNode == null && (objectParent = this.object.getParent()) != null) {
            this.parentNode = new PortalNodeImpl(objectParent, this);
        }
        return this.parentNode;
    }

    public String getName() {
        return this.object.getName();
    }

    public String getDisplayName(Locale locale) {
        String result;
        LocalizedString ldisplayName = this.object.getDisplayName();
        if (ldisplayName != null && (result = ldisplayName.getString(locale, true)) != null) {
            return result;
        }
        if (this.displayNameKey == null) {
            this.displayNameKey = RESOURCE_PREFIX + this.object.getName();
        }
        String displayName = null;
        ResourceBundle bundle = null;
        try {
            bundle = resourceBundles.getResourceBundle(locale);
        }
        catch (MissingResourceException ignore) {
            // empty catch block
        }
        if (bundle != null) {
            try {
                displayName = bundle.getString(this.displayNameKey);
            }
            catch (MissingResourceException ignore) {
                // empty catch block
            }
        }
        if (displayName == null) {
            displayName = this.object.getName();
        }
        return displayName;
    }

    public PortalNode getChild(String name) {
        return (PortalNode)this.children.getMap().get(name);
    }

    public Collection getChildren() {
        return this.children.getList();
    }

    public PortalNode resolve(String relativePath) {
        PortalNodeImpl node = this;
        RelativePathParser cursor = new RelativePathParser(relativePath);
        int i = cursor.next();
        while (i != 0 && node != null) {
            switch (i) {
                case 2: {
                    String name = relativePath.substring(cursor.getOffset(), cursor.getOffset() + cursor.getLength());
                    node = node.getChild(name);
                    break;
                }
                case 1: {
                    node = node.getParent();
                }
            }
            i = cursor.next();
        }
        return node;
    }

    public Map getProperties() {
        return this.object.getProperties();
    }

    public PortalNodeURL createURL(PortalRuntimeContext portalRuntimeContext) {
        PortalRuntimeContextImpl crc = (PortalRuntimeContextImpl)portalRuntimeContext;
        return crc.getURLFactory().createURL(this);
    }

    public PortalObjectId getObjectId() {
        return this.object.getId();
    }

    private float getWeight() {
        switch (this.object.getType()) {
            case 0: {
                return 0.0f;
            }
            case 1: {
                return 1.0f;
            }
            case 2: {
                return 2.0f;
            }
            case 3: {
                return 3.0f;
            }
        }
        return 4.0f;
    }

    private class Siblings
    extends NodeList {
        private PortalNodeImpl node;

        private Siblings(PortalNodeImpl node) {
            this.node = node;
        }

        protected Map createMap() {
            Map<String, PortalNode> childrenNodes = this.buildChildMap(this.node.parentNode);
            childrenNodes.put(this.node.getName(), this.node);
            return childrenNodes;
        }
    }

    private class Children
    extends NodeList {
        private PortalNodeImpl node;

        public Children(PortalNodeImpl node) {
            this.node = node;
        }

        protected Map createMap() {
            return this.buildChildMap(this.node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NodeList {
        private Map map;
        private List list;

        private NodeList() {
        }

        protected abstract Map createMap();

        public final List getList() {
            if (this.list == null) {
                Map childrenMap = this.getMap();
                this.list = new ArrayList(childrenMap.values());
                Collections.sort(this.list, siblingComparator);
                this.list = Collections.unmodifiableList(this.list);
            }
            return this.list;
        }

        public final Map getMap() {
            if (this.map == null) {
                this.map = this.createMap();
            }
            return this.map;
        }

        protected final Map<String, PortalNode> buildChildMap(PortalNodeImpl objectNode) {
            PortalObject object = objectNode.object;
            Collection<PortalObject> tmp = object.getChildren();
            if (tmp.size() > 0) {
                HashMap<String, PortalNode> childrenMap = new HashMap<String, PortalNode>();
                boolean allVisible = PortalNodeImpl.this.portalAuthorizationManager.checkPermission((PortalPermission)new PortalObjectPermission(objectNode.object.getId(), "viewrecursive"));
                for (PortalObject childObject : tmp) {
                    boolean visible = allVisible;
                    if (!visible) {
                        visible = PortalNodeImpl.this.portalAuthorizationManager.checkPermission((PortalPermission)new PortalObjectPermission(childObject.getId(), 1));
                    }
                    if (!visible) continue;
                    PortalNodeImpl child = new PortalNodeImpl(objectNode, childObject);
                    childrenMap.put(child.getName(), child);
                }
                return childrenMap;
            }
            return new HashMap<String, PortalNode>();
        }
    }
}

