/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.mapping;

import java.util.Iterator;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.mapping.PortalObjectPathMapper;
import org.jboss.portal.identity.User;
import org.jboss.portal.server.servlet.PathMapping;
import org.jboss.portal.server.servlet.PathMappingResult;
import org.jboss.portal.server.servlet.PathParser;

public class DashboardPortalObjectPathMapper
implements PortalObjectPathMapper {
    protected PortalObjectContainer container;
    protected CustomizationManager customizationManager;
    protected PathParser pathParser = new PathParser();

    public CustomizationManager getCustomizationManager() {
        return this.customizationManager;
    }

    public void setCustomizationManager(CustomizationManager customizationManager) {
        this.customizationManager = customizationManager;
    }

    public PortalObjectContainer getContainer() {
        return this.container;
    }

    public void setContainer(PortalObjectContainer container) {
        this.container = container;
    }

    public PortalObject getTarget(ControllerContext controllerContext, String path) {
        User user = controllerContext.getUser();
        if (user == null) {
            return this.container.getContext("dashboard");
        }
        Portal dashboard = this.customizationManager.getDashboard(user);
        if (path.length() == 0 || "/".equals(path)) {
            return dashboard;
        }
        DashboardPathMapper mapping = new DashboardPathMapper(dashboard);
        PathMappingResult result = this.pathParser.map((PathMapping)mapping, path);
        return (PortalObject)result.getTarget();
    }

    public void appendPath(StringBuffer buffer, PortalObjectId id) {
        Iterator iterator = id.getPath().names();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            name = FastURLEncoder.getUTF8Instance().encode(name);
            buffer.append('/').append(name);
        }
    }

    private static class DashboardPathMapper
    implements PathMapping {
        private final Portal dashboard;

        public DashboardPathMapper(Portal dashboard) {
            this.dashboard = dashboard;
        }

        public Object getRoot() {
            return this.dashboard;
        }

        public Object getChild(Object parent, String name) {
            PortalObject po = (PortalObject)parent;
            return po.getChild(name);
        }
    }
}

