/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.view;

import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.command.info.ViewCommandInfo;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.command.response.UnavailableResourceResponse;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.ContextCommand;
import org.jboss.portal.core.model.portal.command.response.UpdatePageResponse;
import org.jboss.portal.identity.User;

public class ViewContextCommand
extends ContextCommand {
    private static final CommandInfo info = new ViewCommandInfo();

    public ViewContextCommand(PortalObjectId pageId) {
        super(pageId);
    }

    public CommandInfo getInfo() {
        return info;
    }

    public ControllerResponse execute() throws ControllerException {
        if (this.isDashboard()) {
            User user = this.context.getUser();
            if (user == null) {
                return new ErrorResponse("No authenticated user", false);
            }
            Portal portal = this.context.getController().getCustomizationManager().getDashboard(user);
            if (portal != null) {
                Page page = portal.getDefaultPage();
                return new UpdatePageResponse(page.getId());
            }
            return new UnavailableResourceResponse("Dashboard for user:" + user.getUserName() + " can't be found", false);
        }
        Portal portal = this.root.getDefaultPortal();
        Page page = portal.getDefaultPage();
        return new UpdatePageResponse(page.getId());
    }
}

