/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.metadata;

import java.util.Iterator;
import java.util.List;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.core.model.content.spi.ContentProviderRegistry;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalContainer;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.metadata.BuildContext;
import org.jboss.portal.core.model.portal.metadata.PageMetaData;
import org.jboss.portal.core.model.portal.metadata.PortalObjectMetaData;
import org.jboss.portal.core.model.portal.metadata.coordination.CoordinationMetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.PortletModeMetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.SupportsMetaData;
import org.jboss.portal.portlet.impl.metadata.portlet.WindowStateMetaData;
import org.w3c.dom.Element;

public class PortalMetaData
extends PortalObjectMetaData {
    private SupportsMetaData supportsMetaData = new SupportsMetaData();
    private CoordinationMetaData coordinationMetaData;

    public PortalMetaData() {
        PortletModeMetaData mode = new PortletModeMetaData();
        mode.setPortletMode(Mode.EDIT);
        this.supportsMetaData.addPortletMode(mode);
        mode = new PortletModeMetaData();
        mode.setPortletMode(Mode.VIEW);
        this.supportsMetaData.addPortletMode(mode);
        mode = new PortletModeMetaData();
        mode.setPortletMode(Mode.HELP);
        this.supportsMetaData.addPortletMode(mode);
        mode = new PortletModeMetaData();
        mode.setPortletMode(Mode.ADMIN);
        this.supportsMetaData.addPortletMode(mode);
        mode = new PortletModeMetaData();
        mode.setPortletMode(Mode.EDIT_DEFAULTS);
        this.supportsMetaData.addPortletMode(mode);
        WindowStateMetaData windowState = new WindowStateMetaData();
        windowState.setWindowState(WindowState.MAXIMIZED);
        this.supportsMetaData.addWindowState(windowState);
        windowState = new WindowStateMetaData();
        windowState.setWindowState(WindowState.MINIMIZED);
        this.supportsMetaData.addWindowState(windowState);
        windowState = new WindowStateMetaData();
        windowState.setWindowState(WindowState.NORMAL);
        this.supportsMetaData.addWindowState(windowState);
    }

    public SupportsMetaData getSupportsMetaData() {
        return this.supportsMetaData;
    }

    protected PortalObject newInstance(BuildContext buildContext, PortalObject parent) throws Exception {
        if (!(parent instanceof PortalContainer)) {
            throw new IllegalArgumentException("Not a context");
        }
        Portal portal = ((PortalContainer)parent).createPortal(this.getName());
        Iterator i = this.supportsMetaData.getPortletModes().iterator();
        while (i.hasNext()) {
            Mode mode = ((PortletModeMetaData)i.next()).getPortletMode();
            portal.getSupportedModes().add(mode);
        }
        i = this.supportsMetaData.getWindowStates().iterator();
        while (i.hasNext()) {
            WindowState windowState = ((WindowStateMetaData)i.next()).getWindowState();
            portal.getSupportedWindowStates().add(windowState);
        }
        return portal;
    }

    public static PortalMetaData buildPortalMetaData(ContentProviderRegistry contentProviderRegistry, Element portalElt) throws Exception {
        Element supportedWindowStatesElt;
        PortalMetaData portalMD = new PortalMetaData();
        String portalName = XMLTools.asString((Element)XMLTools.getUniqueChild((Element)portalElt, (String)"portal-name", (boolean)true));
        if (portalName == null || portalName.length() <= 0 || portalName.indexOf(".") >= 0) {
            throw new IllegalArgumentException("Invalid portal-name: '" + portalName + "'. Must not be null, empty or contain a '.'");
        }
        portalMD.setName(portalName);
        Element supportedModesElt = XMLTools.getUniqueChild((Element)portalElt, (String)"supported-modes", (boolean)false);
        if (supportedModesElt != null) {
            PortalMetaData.buildSupportedModes(portalMD, supportedModesElt);
        }
        if ((supportedWindowStatesElt = XMLTools.getUniqueChild((Element)portalElt, (String)"supported-window-states", (boolean)false)) != null) {
            PortalMetaData.buildSupportedWindowStates(portalMD, supportedWindowStatesElt);
        }
        List pageElts = XMLTools.getChildren((Element)portalElt, (String)"page");
        for (int i = 0; i < pageElts.size(); ++i) {
            Element pageElt = (Element)pageElts.get(i);
            PageMetaData pageMD = (PageMetaData)PortalObjectMetaData.buildMetaData(contentProviderRegistry, pageElt);
            portalMD.getChildren().put(pageMD.getName(), pageMD);
        }
        Element coordinationElt = XMLTools.getUniqueChild((Element)portalElt, (String)"coordination", (boolean)false);
        if (coordinationElt != null) {
            portalMD.setCoordinationMetaData(CoordinationMetaData.buildMetaData(coordinationElt));
        }
        return portalMD;
    }

    private void setCoordinationMetaData(CoordinationMetaData coordinationMetaData) {
        this.coordinationMetaData = coordinationMetaData;
    }

    public CoordinationMetaData getCoordinationMetaData() {
        return this.coordinationMetaData;
    }

    public static void buildSupportedModes(PortalMetaData portalMD, Element supportedModesElt) {
        List modeElts = XMLTools.getChildren((Element)supportedModesElt, (String)"mode");
        for (int i = 0; i < modeElts.size(); ++i) {
            Element modeElt = (Element)modeElts.get(i);
            String modeAsString = XMLTools.asString((Element)modeElt);
            PortletModeMetaData mode = new PortletModeMetaData();
            mode.setPortletMode(new Mode(modeAsString));
            portalMD.getSupportsMetaData().addPortletMode(mode);
        }
    }

    public static void buildSupportedWindowStates(PortalMetaData portalMD, Element supportedWindowStatesElt) {
        List windowStates = XMLTools.getChildren((Element)supportedWindowStatesElt, (String)"window-state");
        for (int i = 0; i < windowStates.size(); ++i) {
            Element windowStateElt = (Element)windowStates.get(i);
            String windowStateAsString = XMLTools.asString((Element)windowStateElt);
            WindowStateMetaData windowState = new WindowStateMetaData();
            windowState.setWindowState(new WindowState(windowStateAsString));
            portalMD.getSupportsMetaData().addWindowState(windowState);
        }
    }

    public String toString() {
        return "Portal[" + this.getName() + "]";
    }
}

