/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;

class Context {
    private static Logger log = Logger.getLogger(Context.class);

    Context() {
    }

    static SSLContext forDomain(SecurityDomain securityDomain) throws IOException {
        SSLContext sslCtx = null;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            KeyManagerFactory keyMgr = securityDomain.getKeyManagerFactory();
            if (keyMgr == null) {
                throw new IOException("KeyManagerFactory is null for security domain: " + securityDomain.getSecurityDomain());
            }
            TrustManagerFactory trustMgr = securityDomain.getTrustManagerFactory();
            TrustManager[] trustMgrs = null;
            if (trustMgr != null) {
                trustMgrs = trustMgr.getTrustManagers();
            }
            sslCtx.init(keyMgr.getKeyManagers(), trustMgrs, null);
            return sslCtx;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Failed to get SSLContext for TLS algorithm", (Throwable)e);
            throw new IOException("Failed to get SSLContext for TLS algorithm");
        }
        catch (KeyManagementException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
        catch (SecurityException e) {
            log.error((Object)"Failed to init SSLContext", (Throwable)e);
            throw new IOException("Failed to init SSLContext");
        }
    }
}

