/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.registration;

import org.jboss.logging.Logger;
import org.jboss.portal.common.util.ParameterValidation;

public class RegistrationUtils {
    private static boolean strict = true;
    private static Logger log = Logger.getLogger(RegistrationUtils.class);

    public static void setStrict(boolean strict) {
        RegistrationUtils.strict = strict;
        log.debug((Object)("Using " + (strict ? "strict" : "lenient") + " Consumer Agent validation mode."));
    }

    public static void validateConsumerAgent(String consumerAgent) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNullOrEmpty((String)consumerAgent, (String)"consumer agent", null);
        int periodChar = 46;
        int period = consumerAgent.indexOf(periodChar);
        if (period != -1 && (period = (consumerAgent = consumerAgent.substring(period)).indexOf(periodChar)) != -1) {
            return;
        }
        String msg = "'" + consumerAgent + "' is not a valid Consumer Agent. Please notify your Consumer provider that it is not WSRP-compliant.";
        if (strict) {
            throw new IllegalArgumentException(msg);
        }
        log.debug((Object)msg);
    }
}

