/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.portal.core.identity.services.IdentityUserManagementService;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfigurationService;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.IdentityServiceController;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityUserManagementServiceImpl
extends AbstractJBossService
implements IdentityUserManagementService {
    private UserModule userModule;
    private RoleModule roleModule;
    private UserProfileModule userProfileModule;
    private MembershipModule membershipModule;
    private IdentityServiceController identityServiceController;
    private IdentityUIConfigurationService identityUIConfigurationService;
    private JNDI.Binding jndiBinding;
    private String jndiName = null;

    public void startService() throws Exception {
        super.startService();
        try {
            this.userModule = (UserModule)this.identityServiceController.getIdentityContext().getObject("User");
            this.roleModule = (RoleModule)this.identityServiceController.getIdentityContext().getObject("Role");
            this.userProfileModule = (UserProfileModule)this.identityServiceController.getIdentityContext().getObject("UserProfile");
            this.membershipModule = (MembershipModule)this.identityServiceController.getIdentityContext().getObject("Membership");
        }
        catch (IdentityException e) {
            super.stopService();
            throw new CoreIdentityConfigurationException(e);
        }
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public IdentityServiceController getIdentityServiceController() {
        return this.identityServiceController;
    }

    public void setIdentityServiceController(IdentityServiceController identityServiceController) {
        this.identityServiceController = identityServiceController;
    }

    public UserModule getUserModule() {
        return this.userModule;
    }

    public void setUserModule(UserModule userModule) {
        this.userModule = userModule;
    }

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    public UserProfileModule getUserProfileModule() {
        return this.userProfileModule;
    }

    public void setUserProfileModule(UserProfileModule userProfileModule) {
        this.userProfileModule = userProfileModule;
    }

    public MembershipModule getMembershipModule() {
        return this.membershipModule;
    }

    public void setMembershipModule(MembershipModule membershipModule) {
        this.membershipModule = membershipModule;
    }

    public IdentityUIConfigurationService getIdentityUIConfigurationService() {
        return this.identityUIConfigurationService;
    }

    public void setIdentityUIConfigurationService(IdentityUIConfigurationService identityUIConfigurationService) {
        this.identityUIConfigurationService = identityUIConfigurationService;
    }

    @Override
    public void createUser(String username, String password, Map<String, Object> profileMap, List<String> roles) throws IdentityException {
        if (username == null) {
            throw new IllegalArgumentException("Username may not be null.");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password may not be null.");
        }
        if (profileMap == null) {
            throw new IllegalArgumentException("profileMap may not be null.");
        }
        User user = this.getUserModule().createUser(username, password);
        Set<Role> roleSet = this.checkRoles(roles);
        profileMap.put("portal.user.enabled", Boolean.TRUE);
        for (String key : profileMap.keySet()) {
            Object value = profileMap.get(key);
            this.getUserProfileModule().setProperty(user, key, value);
        }
        this.getMembershipModule().assignRoles(user, roleSet);
    }

    @Override
    public String getCurrentEmail(String username) throws IdentityException {
        if (username == null) {
            throw new IllegalArgumentException("username may not be null.");
        }
        User user = this.getUserModule().findUserByUserName(username);
        return (String)this.getUserProfileModule().getProperty(user, "user.business-info.online.email");
    }

    @Override
    public void updateEmail(String username, String email) throws IdentityException {
        if (username == null) {
            throw new IllegalArgumentException("username may not be null.");
        }
        if (email == null) {
            throw new IllegalArgumentException("email may not be null.");
        }
        User user = this.getUserModule().findUserByUserName(username);
        this.getUserProfileModule().setProperty(user, "user.business-info.online.email", (Object)email);
    }

    private Set<Role> checkRoles(List<String> roles) throws IllegalArgumentException, IdentityException {
        HashSet<Role> roleSet = new HashSet<Role>();
        if (roles == null || roles != null && roles.size() == 0) {
            roles = this.identityUIConfigurationService.getConfiguration().getDefaultRoles();
        }
        if (roles == null || roles != null && roles.size() == 0) {
            roles = new ArrayList<String>();
            roles.add("User");
            this.log.error((Object)"no default roles spezified - please check your configuration");
        }
        if (roles != null && roles.size() > 0) {
            for (String roleName : roles) {
                Role role = this.getRoleModule().findRoleByName(roleName);
                if (role == null) continue;
                roleSet.add(role);
            }
        }
        return roleSet;
    }
}

