/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.workflow.impl;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import javax.naming.InitialContext;
import org.jboss.logging.Logger;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.core.identity.services.IdentityMailService;
import org.jboss.portal.core.identity.services.workflow.UserContainer;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class SendValidationMailAction
implements ActionHandler {
    private IdentityMailService identityMailService;
    private static Logger log = Logger.getLogger(SendValidationMailAction.class);

    public void execute(ExecutionContext ectx) throws Exception {
        HashMap<String, String> emailMap = new HashMap<String, String>();
        String hash = SendValidationMailAction.generateRandomHash();
        String action = (String)ectx.getContextInstance().getVariable("action");
        String email = (String)ectx.getContextInstance().getVariable("email");
        Locale locale = (Locale)ectx.getContextInstance().getVariable("locale");
        if (locale == null) {
            locale = new Locale("en");
        }
        UserContainer uc = (UserContainer)ectx.getContextInstance().getVariable("user");
        if ("register".equals(action)) {
            emailMap.put("to", email);
            emailMap.put("username", uc.getUsername());
            emailMap.put("password", uc.getPassword());
        } else if ("changeEmail".equals(action)) {
            emailMap.put("to", email);
        } else {
            throw new RuntimeException("no actuin defined for SendValidationMail: " + action);
        }
        ectx.getContextInstance().setVariable("validationHash", (Object)hash);
        String portalURL = (String)ectx.getContextInstance().getVariable("portalURL");
        String activationLink = portalURL + "/" + "validateEmail" + "/" + ectx.getProcessInstance().getId() + "/" + hash;
        emailMap.put("activationLink", activationLink);
        this.getIdentityMailService().sendMail(action, emailMap, locale);
    }

    private static String generateRandomHash() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] bytes = new byte[512];
            secureRandom.nextBytes(bytes);
            double rand = secureRandom.nextDouble();
            long time = System.currentTimeMillis();
            String salt = "fuDrupRunEP2BRuspADr";
            StringBuffer buffer = new StringBuffer();
            buffer.append(rand);
            buffer.append(salt);
            buffer.append(time);
            return Tools.md5AsHexString((String)buffer.toString());
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("No Such Algorithm exists " + e));
            return null;
        }
    }

    private IdentityMailService getIdentityMailService() {
        if (this.identityMailService == null) {
            try {
                this.identityMailService = (IdentityMailService)new InitialContext().lookup("java:/portal/IdentityMailService");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.identityMailService;
    }
}

