/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.faces.model.SelectItem;
import org.jboss.portal.common.util.Tools;
import org.jboss.portal.faces.el.PropertyValue;
import org.jboss.portal.faces.el.dynamic.AbstractDynamicBean;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.security.RoleSecurityBinding;
import org.jboss.portal.security.SecurityConstants;
import org.jboss.portal.security.spi.provider.DomainConfigurator;
import org.jboss.portal.security.spi.provider.SecurityConfigurationException;

public abstract class AuthorizationBean {
    public AbstractDynamicBean getForRole() {
        return new AbstractDynamicBean(){

            public Class getType(Object propertyName) {
                return String[].class;
            }

            public PropertyValue getValue(Object propertyName) {
                String[] actions = AuthorizationBean.this.getActionsForRole((String)propertyName);
                return actions != null ? new PropertyValue((Object)actions) : null;
            }

            public boolean setValue(Object propertyName, Object value) {
                return AuthorizationBean.this.setActionsForRole((String)propertyName, (String[])value);
            }
        };
    }

    public boolean setActionsForRole(String roleName, String[] actions) {
        String uri = this.getURI();
        if (uri != null) {
            Set constraints = this.getDomainConfigurator().getSecurityBindings(uri);
            HashMap<String, RoleSecurityBinding> newConstraints = new HashMap<String, RoleSecurityBinding>();
            if (constraints != null) {
                for (RoleSecurityBinding binding : constraints) {
                    newConstraints.put(binding.getRoleName(), binding);
                }
            }
            Set blah = Tools.toSet((Object[])actions);
            newConstraints.put(roleName, new RoleSecurityBinding(blah, roleName));
            try {
                this.getDomainConfigurator().setSecurityBindings(uri, new HashSet(newConstraints.values()));
            }
            catch (SecurityConfigurationException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public String[] getActionsForRole(String roleName) {
        String uri = this.getURI();
        if (uri != null) {
            Set constraints = this.getDomainConfigurator().getSecurityBindings(uri);
            if (constraints != null) {
                HashSet actions = new HashSet();
                for (RoleSecurityBinding binding : constraints) {
                    if (!binding.getRoleName().equals(roleName)) continue;
                    actions.addAll(binding.getActions());
                }
                return actions.toArray(new String[actions.size()]);
            }
            return new String[0];
        }
        return null;
    }

    public String[] getRoles() {
        Set constraints;
        TreeSet<String> roleNames = new TreeSet<String>();
        String uri = this.getURI();
        if (uri != null && (constraints = this.getDomainConfigurator().getSecurityBindings(uri)) != null) {
            for (RoleSecurityBinding binding : constraints) {
                roleNames.add(binding.getRoleName());
            }
        }
        try {
            roleNames.add(SecurityConstants.UNCHECKED_ROLE_NAME);
            for (Role role : this.getRoleModule().findRoles()) {
                roleNames.add(role.getName());
            }
        }
        catch (IdentityException e) {
            e.printStackTrace();
        }
        return roleNames.toArray(new String[roleNames.size()]);
    }

    public Map getRoleDisplayNameMap() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Role role : this.getRoleModule().findRoles()) {
                String displayName = role.getDisplayName();
                if (displayName == null) continue;
                String name = role.getName();
                map.put(name, displayName);
            }
            return map;
        }
        catch (IdentityException e) {
            return Collections.EMPTY_MAP;
        }
    }

    public abstract String submit();

    public abstract String cancel();

    public abstract RoleModule getRoleModule();

    public abstract DomainConfigurator getDomainConfigurator();

    public abstract SelectItem[] getAvailableActions();

    protected abstract String getURI();
}

