/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.services.workflow.impl;

import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.core.identity.services.IdentityUserManagementService;
import org.jboss.portal.core.identity.services.metadata.CoreIdentityConfigurationException;
import org.jboss.portal.core.identity.services.metadata.IdentityUIConfigurationService;
import org.jboss.portal.core.identity.services.workflow.UserContainer;
import org.jboss.portal.core.identity.services.workflow.ValidateEmailService;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.User;
import org.jboss.portal.jems.as.JNDI;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.workflow.service.WorkflowService;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;

public class ValidateEmailServiceImpl
extends AbstractJBossService
implements ValidateEmailService {
    private String processName = "jbp_identity_validate_email";
    private IdentityUIConfigurationService identityUIConfigurationService;
    private IdentityUserManagementService identityUserManagementService;
    private WorkflowService workflowService = null;
    private static final Logger log = Logger.getLogger(ValidateEmailService.class);
    private JNDI.Binding jndiBinding;
    private String jndiName = null;

    public void startService() throws Exception {
        super.startService();
        if (this.jndiName != null) {
            this.jndiBinding = new JNDI.Binding(this.jndiName, (Object)this);
            this.jndiBinding.bind();
        }
    }

    public void stopService() throws Exception {
        super.stopService();
        if (this.jndiBinding != null) {
            this.jndiBinding.unbind();
            this.jndiBinding = null;
        }
    }

    public WorkflowService getWorkflowService() throws CoreIdentityConfigurationException {
        if (this.workflowService == null) {
            this.workflowService = this.identityUIConfigurationService.getWorkflowService();
        }
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setJNDIName(String jndiName) {
        this.jndiName = jndiName;
    }

    public IdentityUIConfigurationService getIdentityUIConfigurationService() {
        return this.identityUIConfigurationService;
    }

    public void setIdentityUIConfigurationService(IdentityUIConfigurationService identityUIConfigurationService) {
        this.identityUIConfigurationService = identityUIConfigurationService;
    }

    public IdentityUserManagementService getIdentityUserManagementService() {
        return this.identityUserManagementService;
    }

    public void setIdentityUserManagementService(IdentityUserManagementService identityUserManagementService) {
        this.identityUserManagementService = identityUserManagementService;
    }

    public String changeEmail(String url, User user, String email, Locale locale) throws CoreIdentityConfigurationException {
        if (!this.identityUIConfigurationService.getConfiguration().enableWorkflow()) {
            try {
                this.getIdentityUserManagementService().updateEmail(user.getUserName(), email);
                return "registered";
            }
            catch (IdentityException e) {
                throw new CoreIdentityConfigurationException("udating the email address failed.", e);
            }
        }
        this.changeEmailWorkflow(url, user, email, locale);
        return "registration_pending";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void changeEmailWorkflow(String url, User user, String email, Locale locale) throws CoreIdentityConfigurationException {
        JbpmContext jbpmContext;
        block3: {
            jbpmContext = null;
            ProcessInstance processInstance = null;
            boolean success = false;
            try {
                jbpmContext = this.getWorkflowService().getJbpmConfiguration().createJbpmContext();
                processInstance = jbpmContext.newProcessInstance(this.processName);
                Token token = processInstance.getRootToken();
                processInstance.getContextInstance().setVariable("portalURL", (Object)url);
                processInstance.getContextInstance().setVariable("user", (Object)new UserContainer(user));
                processInstance.getContextInstance().setVariable("email", (Object)email);
                processInstance.getContextInstance().setVariable("locale", (Object)locale);
                processInstance.getContextInstance().setVariable("action", (Object)"changeEmail");
                token.signal();
                success = true;
                if (processInstance == null || !success) break block3;
            }
            catch (Throwable throwable) {
                if (processInstance != null && success) {
                    jbpmContext.save(processInstance);
                }
                IOTools.safeClose((Object)jbpmContext);
                throw throwable;
            }
            jbpmContext.save(processInstance);
        }
        IOTools.safeClose((Object)jbpmContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validateEmail(String id, String registrationHash) throws CoreIdentityConfigurationException {
        String success = "validation_failed";
        if (!this.identityUIConfigurationService.getConfiguration().enableWorkflow()) {
            return success;
        }
        JbpmContext jbpmContext = null;
        try {
            String hash;
            Token token;
            long processId = Long.valueOf(id);
            jbpmContext = this.getWorkflowService().getJbpmConfiguration().createJbpmContext();
            ProcessInstance processInstance = jbpmContext.getProcessInstance(processId);
            if (processInstance != null && (token = processInstance.getRootToken()) != null && token.getNode().getName().equals("validate_email") && registrationHash.equals(hash = (String)processInstance.getContextInstance().getVariable("validationHash")) && !processInstance.hasEnded()) {
                token.signal("validated");
                success = processInstance.getProcessDefinition().getName();
            }
        }
        catch (Throwable throwable) {
            IOTools.safeClose(jbpmContext);
            throw throwable;
        }
        IOTools.safeClose((Object)jbpmContext);
        return success;
    }
}

