/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.NoSuchResourceException;
import org.jboss.portal.core.controller.SecurityException;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.command.info.ViewCommandInfo;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.core.model.portal.command.PageCommand;
import org.jboss.portal.core.model.portal.command.render.RenderWindowCommand;
import org.jboss.portal.core.model.portal.command.response.MarkupResponse;
import org.jboss.portal.core.model.portal.content.WindowRendition;
import org.jboss.portal.core.model.portal.navstate.WindowNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateKey;
import org.jboss.portal.core.theme.PageRendition;
import org.jboss.portal.core.theme.WindowContextFactory;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManager;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PageService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.ThemeService;
import org.jboss.portal.theme.page.PageResult;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.taskbar.ITaskbarService;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.mt.IMultithreadService;
import org.osivia.portal.core.profils.IProfilManager;

public final class RenderPageCommand
extends PageCommand {
    private static final CommandInfo info = new ViewCommandInfo();
    private Collection<PortalObject> windows;
    private boolean personalizable;
    protected static final Log logger = LogFactory.getLog(RenderPageCommand.class);
    private ITaskbarService taskbarService;
    private IProfilManager profilManager = null;

    public RenderPageCommand(PortalObjectId pageId) {
        super(pageId);
    }

    @Override
    public CommandInfo getInfo() {
        return info;
    }

    public Collection<PortalObject> getWindows() {
        return this.windows;
    }

    @Override
    public void acquireResources() throws NoSuchResourceException {
        super.acquireResources();
        this.windows = new ArrayList<PortalObject>(this.getPage().getChildren(8));
    }

    protected IProfilManager getProfilManager() throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)Locator.findMBean(IProfilManager.class, (String)"osivia:service=ProfilManager");
        }
        return this.profilManager;
    }

    protected ITaskbarService getTaskbarService() throws Exception {
        if (this.taskbarService == null) {
            this.taskbarService = (ITaskbarService)Locator.findMBean(ITaskbarService.class, (String)"osivia:service=TaskbarService");
        }
        return this.taskbarService;
    }

    @Override
    protected Page initPage() {
        return (Page)this.getTarget();
    }

    @Override
    public void enforceSecurity(PortalAuthorizationManager pam) throws SecurityException {
        super.enforceSecurity(pam);
    }

    @Override
    public ControllerResponse execute() throws ControllerException, InvocationException {
        Object response;
        try {
            Object pageResult;
            User user;
            ControllerContext controllerContext = (ControllerContext)this.getContext();
            PageService pageService = this.context.getController().getPageService();
            ThemeService themeService = pageService.getThemeService();
            LayoutService layoutService = pageService.getLayoutService();
            PortalLayout layout = RenderPageCommand.getLayout(layoutService, this.page);
            PortalTheme theme = null;
            ControllerPortletControllerContext portletControllerContext = new ControllerPortletControllerContext(this.context, this.page);
            ControllerPageNavigationalState pageNavigationalState = portletControllerContext.getStateControllerContext().createPortletPageNavigationalState(true);
            if (this.personalizable && (user = controllerContext.getUser()) != null) {
                UserProfileModule userProfileModule = null;
                try {
                    userProfileModule = (UserProfileModule)new InitialContext().lookup("java:portal/UserProfileModule");
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                Map profile = (Map)this.getContext().getAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)"profile");
                String themeId = null;
                themeId = profile == null ? (String)userProfileModule.getProperty(user, "portal.user.theme") : (String)profile.get("portal.user.theme");
                if (themeId != null) {
                    theme = themeService.getThemeById(themeId);
                }
            }
            if (theme == null) {
                String themeId = this.page.getProperty("theme.id");
                theme = themeService.getThemeById(themeId);
            }
            if (this.getControllerContext().getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.popupMode") != null) {
                layout = layoutService.getLayoutById("osivia-popup");
                theme = themeService.getThemeById("osivia-popup");
            }
            InitialContext initialContext = new InitialContext();
            IMultithreadService multithreadService = (IMultithreadService)initialContext.lookup("java:multithread");
            boolean isMultiThreadEnabled = true;
            if ("false".equals(System.getProperty("portlets.enableMultiThread"))) {
                isMultiThreadEnabled = false;
            }
            Set visibleRegions = (Set)this.getControllerContext().getAttribute(Scope.REQUEST_SCOPE, "osivia.layout.visibleRegions");
            String visibleRegionsLayoutState = (String)this.getControllerContext().getAttribute(Scope.REQUEST_SCOPE, "osivia.layout.visibleRegions.parserState");
            TreeSet<Window> filteredWindows = new TreeSet<Window>(new WindowComparator());
            if (this.getControllerContext().getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.popupMode") != null) {
                isMultiThreadEnabled = false;
            }
            for (PortalObject window : this.windows) {
                String region;
                CMSItem spaceConfig;
                String string;
                if (!(window instanceof Window)) continue;
                boolean addWindow = true;
                if (this.getControllerContext().getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.popupMode") != null) {
                    PortalObjectId portalObjectId;
                    if (this.getControllerContext().getServerInvocation().getServerContext().getClientRequest().getAttribute("osivia.popupModeClosing") != null) {
                        addWindow = false;
                    }
                    if ((portalObjectId = (PortalObjectId)((ControllerContext)this.getContext()).getAttribute(ControllerCommand.PRINCIPAL_SCOPE, "osivia.popupModeWindowID")) != null && !window.getId().equals(portalObjectId)) {
                        addWindow = false;
                    }
                }
                if ((string = window.getProperty("osivia.conditionalScope")) != null) {
                    addWindow = false;
                    Boolean isAdmin = (Boolean)controllerContext.getAttribute(Scope.PRINCIPAL_SCOPE, "osivia.isAdmin");
                    if (isAdmin != null && isAdmin.booleanValue()) {
                        addWindow = true;
                    }
                    if (!addWindow) {
                        addWindow = this.getProfilManager().verifierProfilUtilisateur(string);
                    }
                }
                if ((spaceConfig = (CMSItem)this.getControllerContext().getServerInvocation().getServerContext().getClientRequest().getAttribute("osivia.cms.spaceConfig")) != null && addWindow) {
                    PortalControllerContext portalCtx = new PortalControllerContext((Object)this.getContext());
                    String taskbarItemId = window.getDeclaredProperty("osivia.taskbar.linked.id");
                    if (StringUtils.isNotEmpty((String)taskbarItemId)) {
                        addWindow = false;
                        if (StringUtils.isNotEmpty((String)spaceConfig.getPath())) {
                            List tasks = this.getTaskbarService().getTasks(portalCtx, spaceConfig.getPath(), true);
                            for (TaskbarTask task : tasks) {
                                if (!taskbarItemId.equals(task.getId())) continue;
                                if (task.isDisabled()) break;
                                addWindow = true;
                                break;
                            }
                        }
                    }
                }
                if (addWindow && visibleRegions != null && !visibleRegions.contains(region = window.getDeclaredProperty("theme.region"))) {
                    NavigationalStateKey nsKey = new NavigationalStateKey(WindowNavigationalState.class, window.getId());
                    WindowNavigationalState windowNavState = (WindowNavigationalState)((ControllerContext)this.getContext()).getAttribute(ControllerCommand.NAVIGATIONAL_STATE_SCOPE, nsKey);
                    if (windowNavState == null || !WindowState.MAXIMIZED.equals((Object)windowNavState.getWindowState())) {
                        if (StringUtils.equals((String)"virtual", (String)region)) {
                            addWindow = false;
                        } else if (StringUtils.equals((String)"maximized", (String)visibleRegionsLayoutState)) {
                            addWindow = false;
                        } else if ("1".equals(window.getProperty("osivia.dynamic.cmsEditable"))) {
                            addWindow = false;
                        } else if (!StringUtils.equals((String)window.getName(), (String)"menuBarWindow")) {
                            log.warn((Object)("this window seems not to be present in any visible region, should check ... : " + window.getId().toString(PortalObjectPath.CANONICAL_FORMAT)));
                        }
                    }
                }
                if (!addWindow) continue;
                filteredWindows.add((Window)window);
            }
            if (multithreadService != null && isMultiThreadEnabled) {
                response = pageResult = multithreadService.execute(this.page, this.context, filteredWindows, layout, theme, pageService, pageNavigationalState);
            } else {
                pageResult = new PageResult(this.getPage().getName(), new HashMap<String, String>(this.getPage().getProperties()));
                WindowContextFactory wcFactory = new WindowContextFactory(this.context);
                response = null;
                for (PortalObject portalObject : filteredWindows) {
                    ControllerResponse controllerResponse;
                    if (!(portalObject instanceof Window)) continue;
                    Window window = (Window)portalObject;
                    RenderWindowCommand renderCmd = new RenderWindowCommand(pageNavigationalState, window.getId());
                    WindowRendition rendition = null;
                    if (renderCmd != null) {
                        rendition = renderCmd.render(this.context);
                    }
                    if (rendition == null || (controllerResponse = rendition.getControllerResponse()) == null) continue;
                    if (controllerResponse instanceof MarkupResponse) {
                        pageResult.addWindowContext(wcFactory.createWindowContext(window, rendition));
                        continue;
                    }
                    if (controllerResponse == null) continue;
                    response = controllerResponse;
                    break;
                }
                if (response == null) {
                    response = new PageRendition(layout, theme, (PageResult)pageResult, pageService);
                }
            }
            controllerContext.removeAttribute(Scope.PRINCIPAL_SCOPE, "osivia.ajax.action");
        }
        catch (Exception e) {
            response = null;
            RenderPageCommand.rethrow(e);
        }
        return response;
    }

    public static PortalLayout getLayout(LayoutService layoutService, Page page) {
        String layoutIdString = page.getProperty("layout.id");
        return layoutService.getLayoutById(layoutIdString);
    }

    private class WindowComparator
    implements Comparator<Window> {
        private WindowComparator() {
        }

        @Override
        public int compare(Window w1, Window w2) {
            String order1 = w1.getDeclaredProperty("osivia.sequence.priority");
            String order2 = w2.getDeclaredProperty("osivia.sequence.priority");
            if (order1 == null) {
                if (order2 == null) {
                    return w1.getName().compareTo(w2.getName());
                }
                return -1;
            }
            if (order2 == null) {
                return 1;
            }
            return Integer.valueOf(order1).compareTo(Integer.valueOf(order2));
        }
    }
}

