/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Implode
extends Task {
    private static final Set extensions = new HashSet<String>(Arrays.asList("ear", "war", "sar", "har"));
    private File dir;
    private File tofile;

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setTofile(File tofile) {
        this.tofile = tofile;
    }

    public void execute() throws BuildException {
        if (this.tofile == null) {
            throw new BuildException("target file should not be null");
        }
        if (this.dir == null) {
            throw new BuildException("source dir should not be null");
        }
        if (!this.dir.exists()) {
            throw new BuildException("source dir does not exist");
        }
        if (this.dir.isFile()) {
            throw new BuildException("source dir is a file");
        }
        if (this.tofile.exists() && this.tofile.isDirectory()) {
            throw new BuildException("target file " + this.tofile + " designates a directory");
        }
        OutputStream out = null;
        try {
            byte[] bytes = this.implode(this.dir);
            out = new BufferedOutputStream(new FileOutputStream(this.tofile));
            out.write(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public byte[] implode(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream(baos);
        this.implode(f, "", out);
        out.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void implode(File f, String path, JarOutputStream out) throws IOException {
        if (f.isFile()) {
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(f));
                byte[] bytes = new byte[1024];
                String fileName = path.substring(1);
                JarEntry fileEntry = new JarEntry(fileName);
                out.putNextEntry(fileEntry);
                int l = in.read(bytes, 0, bytes.length);
                while (l > 0) {
                    out.write(bytes, 0, l);
                    l = in.read(bytes, 0, bytes.length);
                }
                out.closeEntry();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        if (path.length() > 1) {
            String dirName = path.substring(1) + '/';
            JarEntry dirEntry = new JarEntry(dirName);
            out.putNextEntry(dirEntry);
            out.closeEntry();
        }
        File[] children = f.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File child = children[i];
            int lastDot = child.getName().lastIndexOf(".");
            if (extensions.contains(child.getName().substring(lastDot + 1))) {
                byte[] bytes = this.implode(child);
                String fileName = (path + '/' + child.getName()).substring(1);
                JarEntry fileEntry = new JarEntry(fileName);
                out.putNextEntry(fileEntry);
                out.write(bytes, 0, bytes.length);
                out.closeEntry();
                continue;
            }
            this.implode(child, path + '/' + child.getName(), out);
        }
    }
}

