/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.cms.repository.model.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.nuxeo.ecm.automation.client.model.NxDocumentMock;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.model.Document;
import org.osivia.portal.api.cms.model.Templateable;
import org.osivia.portal.api.cms.repository.BaseUserRepository;

public class RepositoryDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 6260858468002991204L;
    private String internalID;
    private final Map<String, Object> properties;
    private final String spaceInternalId;
    protected transient String parentInternalId;
    protected transient List<String> childrenId;
    protected transient BaseUserRepository userRepository;
    private EcmDocument nativeItem;
    private Locale locale;
    private final Long timestamp;
    protected transient boolean preview = false;
    public List<String> supportedSubTypes = new ArrayList<String>();

    @Override
    public String getType() {
        return this.nativeItem.getType();
    }

    public List<String> getSupportedSubTypes() {
        return this.supportedSubTypes;
    }

    public RepositoryDocument(BaseUserRepository userRepository, EcmDocument nativeItem, String internalID, String name, String parentId, String spaceId, List<String> childrenId, Map<String, Object> properties) {
        this.userRepository = userRepository;
        this.internalID = internalID;
        this.nativeItem = nativeItem;
        this.parentInternalId = parentId;
        this.spaceInternalId = spaceId;
        this.childrenId = childrenId;
        this.properties = properties;
        this.preview = userRepository.isPreviewRepository();
        this.locale = userRepository.getRepositoryKey().getLocale();
        this.timestamp = System.currentTimeMillis();
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isPreview() {
        return this.preview;
    }

    public String getInternalID() {
        return this.internalID;
    }

    @Override
    public UniversalID getId() {
        return new UniversalID(this.userRepository.getRepositoryName(), this.getInternalID());
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getTitle() {
        return this.nativeItem.getTitle();
    }

    public void setTitle(String title) {
        ((NxDocumentMock)this.nativeItem).setTitle(title);
    }

    public String getSpaceInternalId() {
        return this.spaceInternalId;
    }

    @Override
    public UniversalID getSpaceId() {
        if (this.getSpaceInternalId() != null) {
            return new UniversalID(this.userRepository.getRepositoryName(), this.getSpaceInternalId());
        }
        return null;
    }

    public String getParentInternalId() {
        return this.parentInternalId;
    }

    public List<String> getChildrenId() {
        return this.childrenId;
    }

    public String getName() {
        return ((NxDocumentMock)this.nativeItem).getName();
    }

    public boolean isNavigable() {
        return false;
    }

    public void setParentInternalId(String parentInternalId) {
        this.parentInternalId = parentInternalId;
    }

    public void setPath(String path) {
        ((NxDocumentMock)this.nativeItem).setPath(path);
    }

    @Override
    public EcmDocument getNativeItem() {
        return this.nativeItem;
    }

    public RepositoryDocument duplicateForPublication(String parentInternalId, List<String> childrenId, BaseUserRepository userRepository) throws CloneNotSupportedException {
        RepositoryDocument newDoc = (RepositoryDocument)SerializationUtils.clone((Serializable)this);
        newDoc.parentInternalId = parentInternalId;
        newDoc.childrenId = childrenId;
        newDoc.userRepository = userRepository;
        return newDoc;
    }

    public RepositoryDocument duplicate() throws CloneNotSupportedException {
        RepositoryDocument newDoc = (RepositoryDocument)SerializationUtils.clone((Serializable)this);
        newDoc.parentInternalId = this.getParentInternalId();
        newDoc.childrenId = this.getChildrenId();
        newDoc.userRepository = this.userRepository;
        newDoc.preview = this.isPreview();
        return newDoc;
    }

    public RepositoryDocument duplicateForNewId(String newId) throws CloneNotSupportedException {
        RepositoryDocument newDoc = (RepositoryDocument)SerializationUtils.clone((Serializable)this);
        newDoc.parentInternalId = this.getParentInternalId();
        newDoc.childrenId = this.getChildrenId();
        newDoc.userRepository = this.userRepository;
        newDoc.preview = this.isPreview();
        newDoc.internalID = newId;
        return newDoc;
    }

    @Override
    public boolean isTemplateable() {
        return this instanceof Templateable;
    }
}

