/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

@Deprecated
public final class MediaType {
    private static Map allowedTypes = new HashMap();
    private static Map supportedExtensions = new HashMap();
    public static final MediaType ANY = new MediaType("*", "*", new String[0]);
    public static final MediaType XHTML = new MediaType("application", "xhtml+xml", new String[]{"xhtml"});
    public static final MediaType HTML = new MediaType("text", "html", new String[]{"html", "htm"}, new MediaType[]{XHTML});
    public static final MediaType FORM = new MediaType("application", "x-www-form-urlencoded", new String[0]);
    public static final MediaType XML = new MediaType("text", "xml", new String[]{"xml"}, new MediaType[]{XHTML});
    public static final MediaType WML = new MediaType("text", "vnd.wap.wml", new String[]{"wml"});
    public static final MediaType CSS = new MediaType("text", "css", new String[]{"css"});
    public static final MediaType TEXT = new MediaType("text", "plain", new String[]{"txt"});
    public static final MediaType JS = new MediaType("text", "javascript", new String[]{"js"});
    public static final MediaType SVG = new MediaType("image", "svg+xml", new String[]{"svg"});
    public static final MediaType JPEG = new MediaType("image", "jpeg", new String[]{"jpeg", "jpg"});
    public static final MediaType GIF = new MediaType("image", "gif", new String[]{"gif"});
    public static final MediaType PNG = new MediaType("image", "png", new String[]{"png"});
    public static final MediaType WBMP = new MediaType("image", "vnd.wap.wbmp", new String[]{"wbpm"});
    public static final MediaType RSS = new MediaType("application", "rss+xml", new String[0]);
    public static final MediaType ICO = new MediaType("application", "octet-stream", new String[]{"ico"});
    private MimeType m_mimeType = null;
    private MediaType[] m_allowedSubTypes;
    private Set allowSubTypeSet;

    private MediaType(String primaryType, String subType, String[] extensions) {
        try {
            this.m_mimeType = new MimeType(primaryType, subType);
            this.m_allowedSubTypes = null;
            this.allowSubTypeSet = null;
            allowedTypes.put(this.m_mimeType.getBaseType(), this);
            for (int i = 0; i < extensions.length; ++i) {
                supportedExtensions.put(extensions[i], this);
            }
        }
        catch (MimeTypeParseException e) {
            System.out.println(e.getMessage());
        }
    }

    private MediaType(String primaryType, String subType, String[] extensions, MediaType[] allowedSubTypes) {
        this(primaryType, subType, extensions);
        if (this.m_mimeType != null) {
            this.m_allowedSubTypes = allowedSubTypes;
            this.allowSubTypeSet = new HashSet<MediaType>(Arrays.asList(allowedSubTypes));
        }
    }

    public static MediaType parseMimeType(String mimeType) throws MimeTypeParseException {
        if (mimeType == null || "".equals(mimeType)) {
            throw new IllegalArgumentException("no valid mime type provided");
        }
        String type = mimeType.trim().toLowerCase();
        if (allowedTypes.keySet().contains(type)) {
            return (MediaType)allowedTypes.get(type);
        }
        throw new MimeTypeParseException("Type [" + mimeType + "] not supported");
    }

    public static MediaType parseMimeTypeByExtension(String extension) throws MimeTypeParseException {
        if (extension == null || "".equals(extension)) {
            throw new IllegalArgumentException("no valid mime type provided [" + extension + "]");
        }
        String ext = extension.trim().toLowerCase();
        if (supportedExtensions.keySet().contains(ext)) {
            return (MediaType)supportedExtensions.get(ext);
        }
        throw new MimeTypeParseException("Extension [" + extension + "] not supported");
    }

    public static List getAllowedSubTypes(MediaType mimeType) {
        if (mimeType.m_allowedSubTypes == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(mimeType.m_allowedSubTypes));
    }

    public List getAllowedSubTypes() {
        if (this.m_allowedSubTypes == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(this.m_allowedSubTypes));
    }

    public boolean isAllowedSubType(MediaType other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.allowSubTypeSet == null) {
            return false;
        }
        return this.allowSubTypeSet.contains(other);
    }

    public String toString() {
        return this.m_mimeType.getBaseType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaType)) {
            return false;
        }
        MediaType type = (MediaType)o;
        return this.m_mimeType.equals(type.m_mimeType);
    }

    public int hashCode() {
        return this.m_mimeType.hashCode();
    }
}

