/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import org.jboss.portal.theme.FQN;

public class ServerRegistrationID
extends FQN {
    private static final long serialVersionUID = 8042337046523234207L;
    private String desc = null;
    private Type type;
    public static final Type TYPE_THEME = new Type("theme");
    public static final Type TYPE_LAYOUT = new Type("layout");
    public static final Type TYPE_RENDERSET = new Type("renderSet");

    private ServerRegistrationID(Type type, String[] names) {
        super(names);
        this.type = type;
    }

    public static ServerRegistrationID createID(Type type, String[] names) {
        return new ServerRegistrationID(type, names);
    }

    @Override
    public String toString() {
        if (this.desc == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.names[0]);
            for (int i = 1; i < this.names.length; ++i) {
                buffer.append('.').append(this.names[i]);
            }
            this.desc = buffer.toString();
        }
        return this.desc;
    }

    public static ServerRegistrationID createPortalThemeID(String appID, String name) throws IllegalArgumentException {
        return new ServerRegistrationID(TYPE_THEME, new String[]{appID, name});
    }

    public static ServerRegistrationID createPortalLayoutID(String appID, String name) throws IllegalArgumentException {
        return new ServerRegistrationID(TYPE_LAYOUT, new String[]{appID, name});
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServerRegistrationID)) {
            return false;
        }
        ServerRegistrationID other = (ServerRegistrationID)obj;
        if (other.names.length != this.names.length) {
            return false;
        }
        if (other.type != this.type) {
            return false;
        }
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i].equals(other.names[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int tmp = this.type.hashCode();
        for (int i = 0; i < this.names.length; ++i) {
            tmp = tmp * 29 + this.names[i].hashCode();
        }
        return tmp;
    }

    public static class Type {
        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Type) {
                Type that = (Type)o;
                return this.type.equals(that.type);
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.type;
        }
    }
}

