/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl.render.dynamic;

import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.portal.theme.impl.render.dynamic.DynaMergeBehavior;
import org.jboss.portal.theme.impl.render.dynamic.DynaRenderOptions;
import org.jboss.portal.theme.impl.render.dynamic.DynaRenderStatus;
import org.jboss.portal.theme.render.AbstractObjectRenderer;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.PropertyFetch;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.renderer.RegionRenderer;
import org.jboss.portal.theme.render.renderer.RegionRendererContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.theming.IPageHeaderResourceService;

public class DynaRegionRenderer
extends AbstractObjectRenderer
implements RegionRenderer {
    private static final PropertyFetch RENDER_OPTIONS_FETCH = new PropertyFetch(1);
    private static IPageHeaderResourceService pageHeaderResourceService = null;
    private RegionRenderer delegate;

    public DynaRegionRenderer(RegionRenderer regionRenderer) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.delegate = regionRenderer;
    }

    private IPageHeaderResourceService getPageHeaderService() {
        if (pageHeaderResourceService == null) {
            pageHeaderResourceService = (IPageHeaderResourceService)Locator.findMBean(IPageHeaderResourceService.class, (String)"osivia:service=PageHeaderResourceService");
        }
        return pageHeaderResourceService;
    }

    @Override
    public void startContext(RendererContext rendererContext, ObjectRendererContext objectRenderContext) {
        RegionRendererContext rrc = (RegionRendererContext)objectRenderContext;
        if ("AJAXScripts".equals(rrc.getId()) || "AJAXFooter".equals(rrc.getId())) {
            DynaRenderStatus.set(rendererContext, false);
        } else {
            String ancestorsDndValue = rendererContext.getProperty("theme.dyna.dnd_enabled", RENDER_OPTIONS_FETCH);
            String ancestorsPartialRefreshValue = rendererContext.getProperty("theme.dyna.partial_refresh_enabled", RENDER_OPTIONS_FETCH);
            DynaRenderOptions ancestorsOptions = DynaRenderOptions.getOptions(ancestorsDndValue, ancestorsPartialRefreshValue);
            String regionDndValue = rendererContext.getProperty("theme.dyna.dnd_enabled");
            String regionPartialRefreshValue = rendererContext.getProperty("theme.dyna.partial_refresh_enabled");
            DynaRenderOptions regionOptions = DynaRenderOptions.getOptions(regionDndValue, regionPartialRefreshValue);
            DynaRenderOptions options = DynaMergeBehavior.mergeForRegion(ancestorsOptions, regionOptions);
            rendererContext.setAttribute("dyna_render_options", options);
            DynaRenderStatus.set(rendererContext, true);
        }
    }

    @Override
    public void endContext(RendererContext rendererContext, ObjectRendererContext objectRenderContext) {
        if (DynaRenderStatus.isActive(rendererContext)) {
            rendererContext.setAttribute("dyna_render_options", null);
        }
    }

    @Override
    public void renderHeader(RendererContext rendererContext, RegionRendererContext rrc) throws RenderException {
        PrintWriter markup = rendererContext.getWriter();
        String jsBase = rendererContext.getProperty("theme.dyna.resource_base_url");
        String serverBaseURL = rendererContext.getProperty("theme.dyna.server_base_url");
        String viewState = rendererContext.getProperty("theme.dyna.view_state");
        String sessionCheck = rendererContext.getProperty("theme.dyna.session_check");
        if ("AJAXScripts".equals(rrc.getId())) {
            try {
                this.writeResource(markup, "<script type='text/javascript' src='" + jsBase + "/dyna.js'></script>");
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
            markup.print("<script type='text/javascript'>\n");
            markup.print("server_base_url=\"");
            markup.print(serverBaseURL);
            markup.print("\";\n");
            if (viewState != null) {
                markup.print("view_state = \"");
                markup.print(viewState);
                markup.print("\";\n");
            } else {
                markup.print("view_state = null;");
            }
            if (sessionCheck != null) {
                markup.print("session_check = \"");
                markup.print(sessionCheck);
                markup.print("\";\n");
            } else {
                markup.print("session_check = null;");
            }
            markup.print("portal_redirection = null;");
            markup.print("</script>\n");
        } else if ("AJAXFooter".equals(rrc.getId())) {
            markup.print("<script type='text/javascript'>footer()</script>\n");
        }
        if (DynaRenderStatus.isActive(rendererContext)) {
            DynaRenderOptions options = (DynaRenderOptions)rendererContext.getAttribute("dyna_render_options");
            if (!DynaRenderOptions.NO_AJAX.equals(options)) {
                markup.print("<div class=\"dyna-region\">");
                this.delegate.renderHeader(rendererContext, rrc);
                if (options.isDnDEnabled()) {
                    markup.print("<div class=\"dnd-region\" id=\"");
                    markup.print(rrc.getId());
                    markup.print("\">");
                }
            } else {
                this.delegate.renderHeader(rendererContext, rrc);
            }
        }
    }

    private void writeResource(PrintWriter out, String resource) throws IOException {
        out.write(this.getPageHeaderService().adaptResourceElement(resource));
    }

    @Override
    public void renderBody(RendererContext rendererContext, RegionRendererContext rrc) throws RenderException {
        if (DynaRenderStatus.isActive(rendererContext)) {
            this.delegate.renderBody(rendererContext, rrc);
        }
    }

    @Override
    public void renderFooter(RendererContext rendererContext, RegionRendererContext rrc) throws RenderException {
        if (DynaRenderStatus.isActive(rendererContext)) {
            DynaRenderOptions options = (DynaRenderOptions)rendererContext.getAttribute("dyna_render_options");
            if (!DynaRenderOptions.NO_AJAX.equals(options)) {
                PrintWriter markup = rendererContext.getWriter();
                if (options.isDnDEnabled()) {
                    markup.print("</div>");
                }
                markup.print("</div>");
            }
            this.delegate.renderFooter(rendererContext, rrc);
        }
    }
}

