/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.api.portalobject.bridge;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.portalobject.bridge.PortalBridge;
import org.osivia.portal.core.page.PageProperties;

public class PortalObjectUtils {
    private static PortalBridge bridgeService = null;

    private static PortalBridge getService() {
        if (bridgeService == null) {
            bridgeService = (PortalBridge)Locator.getService(PortalBridge.class);
        }
        return bridgeService;
    }

    public static final PortalObjectId getPageId(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().getPageId(portalCtx);
    }

    public static final Page getPage(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().getPage(portalCtx);
    }

    public static final boolean isDefaultMemberPage(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().isDefaultMemberPage(portalCtx);
    }

    public static final Portal getPortal(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().getPortal(portalCtx);
    }

    public static final String getPortalName(PortalControllerContext controllerContext) {
        String portalName = PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        return portalName;
    }

    public static final boolean isAdmin(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().isAdmin(portalCtx);
    }

    public static final boolean isPageRepositoryManager(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().isPageRepositoryManager(portalCtx);
    }

    public static final Portal getPortal(PortalObject po) {
        Window window;
        Page page;
        Portal portal = null;
        if (po instanceof Portal) {
            portal = (Portal)po;
        } else if (po instanceof Page) {
            Page page2 = (Page)po;
            portal = page2.getPortal();
        } else if (po instanceof Window && (page = (window = (Window)po).getPage()) != null) {
            portal = page.getPortal();
        }
        return portal;
    }

    public static final boolean isSpaceSite(PortalObject po) {
        if (po == null) {
            return false;
        }
        Portal portal = PortalObjectUtils.getPortal(po);
        if (portal == null) {
            return false;
        }
        String portalType = portal.getProperty("osivia.portal.portalType");
        return StringUtils.equals((CharSequence)"space", (CharSequence)portalType);
    }

    public static String getHTMLSafeId(PortalObjectId id) {
        if (id == null) {
            return null;
        }
        String safestFormat = id.toString(PortalObjectPath.SAFEST_FORMAT);
        try {
            return URLEncoder.encode(safestFormat, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Window getMaximizedWindow(PortalControllerContext portalControllerContext, Page page) {
        return PortalObjectUtils.getService().getMaximizedWindow(portalControllerContext, page);
    }

    public static PortalObject getObject(PortalControllerContext portalCtx, PortalObjectId id) throws IllegalArgumentException {
        return PortalObjectUtils.getService().getObject(portalCtx, id);
    }

    public static List<?> getDomains(PortalControllerContext portalCtx) throws IllegalArgumentException {
        return PortalObjectUtils.getService().getDomains(portalCtx);
    }

    public static String getPortalContextPath(PortalControllerContext portalCtx) {
        return PortalObjectUtils.getService().getPortalContextPath(portalCtx);
    }

    public static void setPortalSessionAttribute(PortalControllerContext portalCtx, String name, Object object) {
        PortalObjectUtils.getService().setPortalSessionAttribute(portalCtx, name, object);
    }

    public static Object getPortalSessionAttribute(PortalControllerContext portalCtx, String name) {
        return PortalObjectUtils.getService().getPortalSessionAttribute(portalCtx, name);
    }

    public static boolean isUserRefreshingPage() {
        return PortalObjectUtils.getService().isRefreshingPage();
    }

    public static String getHostErrorPageURI(HttpServletRequest request) {
        return PortalObjectUtils.getService().getHostErrorPageURI(request);
    }

    public static String getHostCharteContext(HttpServletRequest request) {
        return PortalObjectUtils.getService().getHostCharteContext(request);
    }

    public static UniversalID getHostPortalID(HttpServletRequest request) {
        return PortalObjectUtils.getService().getHostPortalID(request);
    }

    public static boolean isRepositoryCompatibleWithHost(HttpServletRequest request, String repository) {
        return PortalObjectUtils.getService().checkIfRepositoryIsCompatibleWithHost(request, repository);
    }
}

