/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.page;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.core.cms.CMSConfigurationItem;

public class PageProperties {
    private Set<CMSConfigurationItem> regionLayouts;
    private Subject binarySubject;
    protected static final Log logger = LogFactory.getLog(PageProperties.class);
    public static ThreadLocal<PageProperties> localProperties = new ThreadLocal();
    private boolean refreshingPage = false;
    private Long checkingSpaceTS = null;
    private Long checkingSpaceBeginning = null;
    private Map<String, String> pageMap = null;
    private Map<String, Object> requestCache = null;
    private PageProperties parent;
    private Map<String, Map<String, String>> windowProperties = null;
    private String currentWindowId;

    public Subject getBinarySubject() {
        return this.binarySubject;
    }

    public void setBinarySubject(Subject binarySubject) {
        this.binarySubject = binarySubject;
    }

    public PageProperties() {
    }

    public PageProperties(Map<String, Map<String, String>> properties, Map<String, String> pageMap, Map<String, Object> requestCache) {
        this.windowProperties = properties;
        this.pageMap = pageMap;
        this.requestCache = requestCache;
    }

    public static PageProperties getProperties() {
        if (localProperties.get() == null) {
            localProperties.set(new PageProperties());
        }
        return localProperties.get();
    }

    public boolean isRefreshingPage() {
        if (this.parent != null) {
            return this.parent.isRefreshingPage();
        }
        return this.refreshingPage;
    }

    public boolean isCheckingSpaceContents() {
        return this.getCheckingSpaceTs() != null;
    }

    public void setRefreshingPage(boolean pageRefresh) {
        if (this.parent != null) {
            this.parent.refreshingPage = pageRefresh;
        } else {
            this.refreshingPage = pageRefresh;
        }
    }

    public void setCheckingSpaceTS(Long spaceTs) {
        if (this.parent != null) {
            this.parent.checkingSpaceTS = spaceTs;
            this.parent.checkingSpaceBeginning = System.currentTimeMillis();
        } else {
            this.checkingSpaceTS = spaceTs;
            this.checkingSpaceBeginning = System.currentTimeMillis();
        }
    }

    public Long getCheckingSpaceTs() {
        if (this.parent != null) {
            return this.parent.getCheckingSpaceTs();
        }
        return this.checkingSpaceTS;
    }

    public Long getCheckingSpaceBeginning() {
        if (this.parent != null) {
            return this.parent.checkingSpaceBeginning;
        }
        return this.checkingSpaceBeginning;
    }

    public Map<String, String> getPagePropertiesMap() {
        Map<String, String> pageProperties = this.parent == null ? this.pageMap : this.parent.pageMap;
        return pageProperties;
    }

    public Map<String, Object> getPageRequestCache() {
        Map<String, Object> requestCache = this.parent == null ? this.requestCache : this.parent.requestCache;
        return requestCache;
    }

    public static void createThreadContext(PageProperties parent) {
        PageProperties newBean = new PageProperties();
        newBean.parent = parent;
        localProperties.set(newBean);
    }

    public String getWindowProperty(String windowId, String propertyName) {
        if (this.parent != null) {
            return this.parent.getWindowProperty(windowId, propertyName);
        }
        if (this.windowProperties.get(windowId) != null) {
            return this.windowProperties.get(windowId).get(propertyName);
        }
        return null;
    }

    public void setWindowProperty(String windowId, String propertyName, String propertyValue) {
        if (this.parent != null) {
            this.parent.setWindowProperty(windowId, propertyName, propertyValue);
            return;
        }
        if (this.windowProperties.get(windowId) == null) {
            this.windowProperties.put(windowId, new Hashtable());
        }
        if (propertyValue != null) {
            this.windowProperties.get(windowId).put(propertyName, propertyValue);
        }
    }

    public String getCurrentWindowId() {
        return this.currentWindowId;
    }

    public void setCurrentWindowId(String currentWindowId) {
        this.currentWindowId = currentWindowId;
    }

    public static void init() {
        localProperties.set(new PageProperties(new Hashtable<String, Map<String, String>>(), new Hashtable<String, String>(), new Hashtable<String, Object>()));
    }

    public static void remove() {
        localProperties.remove();
    }

    public Set<CMSConfigurationItem> getRegionLayouts() {
        return this.regionLayouts;
    }

    public void setRegionLayouts(Set<CMSConfigurationItem> regionLayouts) {
        this.regionLayouts = regionLayouts;
    }
}

