/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public final class URLUtils {
    public static final String VIRTUAL_HOST_REQUEST_HEADER = "osivia-virtual-host";

    private URLUtils() {
        throw new AssertionError();
    }

    public static final String createUrl(HttpServletRequest request, String uri, Map<String, String> parameters) {
        if (request == null) {
            return null;
        }
        String path = uri;
        if (path == null) {
            path = "";
        }
        StringBuffer buffer = new StringBuffer();
        String virtualHost = request.getHeader(VIRTUAL_HOST_REQUEST_HEADER);
        if (StringUtils.isBlank((CharSequence)virtualHost)) {
            String scheme = request.getScheme();
            String host = request.getServerName();
            int port = request.getServerPort();
            try {
                URL url = port != 80 ? new URL(scheme, host, port, path) : new URL(scheme, host, path);
                buffer.append(url);
            }
            catch (MalformedURLException e1) {
                return null;
            }
        } else {
            buffer.append(virtualHost);
            buffer.append(path);
        }
        if (parameters != null) {
            boolean firstParameter = true;
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                try {
                    String name = URLEncoder.encode(entry.getKey(), "UTF-8");
                    String value = URLEncoder.encode(entry.getValue(), "UTF-8");
                    if (firstParameter) {
                        buffer.append("?");
                        firstParameter = false;
                    } else {
                        buffer.append("&");
                    }
                    buffer.append(name);
                    buffer.append("=");
                    buffer.append(value);
                }
                catch (UnsupportedEncodingException e) {}
            }
        }
        return buffer.toString();
    }

    public static final String createUrl(HttpServletRequest request) {
        return URLUtils.createUrl(request, null, null);
    }

    public static final String addParameter(String url, String name, String value) {
        if (url == null || name == null) {
            return null;
        }
        String safeName = name;
        String safeValue = value;
        if (safeValue == null) {
            safeValue = "";
        }
        try {
            safeName = URLEncoder.encode(safeName, "UTF-8");
            safeValue = URLEncoder.encode(safeValue, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        String separator = "?";
        if (url.indexOf("?") >= 0) {
            separator = "&";
        }
        StringBuffer buffer = new StringBuffer(url);
        buffer.append(separator);
        buffer.append(safeName);
        buffer.append("=");
        buffer.append(safeValue);
        return buffer.toString();
    }
}

