/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.Symlink;
import org.osivia.portal.core.cms.DocumentsMetadata;

public class DocumentsMetadataImpl
implements DocumentsMetadata {
    public static final String WEB_ID_PROPERTY = "ttc:webid";
    public static final String WEB_URL_SEGMENT_PROPERTY = "ottcweb:segment";
    public static final String MODIFIED_PROPERTY = "dc:modified";
    private static final String WEB_ID_PATH_PREFIX = "/id_";
    private final String basePath;
    private final List<Document> documents;
    private final List<Symlink> symlinks;
    private final Map<String, String> webIds;
    private final Map<String, PathValues> paths;
    private final Map<SegmentKey, String> segments;
    private final Map<String, String> toWebPaths;
    private final Map<String, String> fromWebPaths;
    private long timestamp;

    public DocumentsMetadataImpl(String basePath, List<Document> documents, List<Symlink> symlinks) {
        this.basePath = basePath;
        this.documents = documents;
        this.symlinks = symlinks;
        this.webIds = new ConcurrentHashMap<String, String>(this.documents.size());
        this.paths = new ConcurrentHashMap<String, PathValues>(this.documents.size() + this.symlinks.size());
        this.segments = new ConcurrentHashMap<SegmentKey, String>(this.documents.size() + this.symlinks.size());
        this.toWebPaths = new ConcurrentHashMap<String, String>(this.documents.size());
        this.fromWebPaths = new ConcurrentHashMap<String, String>(this.documents.size());
        for (Symlink symlink : this.symlinks) {
            this.paths.put(symlink.getVirtualPath(), new PathValues(symlink.getTargetWebId(), symlink.getSegment()));
            this.segments.put(new SegmentKey(symlink.getParentPath(), symlink.getSegment()), symlink.getTargetPath());
        }
        this.timestamp = 0L;
        for (Document document : documents) {
            String path = StringUtils.removeEnd((String)document.getPath(), (String)".proxy");
            String webId = document.getString(WEB_ID_PROPERTY);
            String segment = document.getString(WEB_URL_SEGMENT_PROPERTY);
            Date modified = document.getDate(MODIFIED_PROPERTY);
            if (webId != null) {
                this.webIds.put(webId, path);
            }
            if (webId != null || segment != null) {
                this.paths.put(path, new PathValues(webId, segment));
            }
            if (!path.equals(basePath) && segment != null) {
                this.segments.put(new SegmentKey(StringUtils.substringBeforeLast((String)path, (String)"/"), segment), path);
            }
            if (modified == null) continue;
            this.timestamp = Math.max(this.timestamp, modified.getTime());
        }
        this.timestamp += 10L;
    }

    public String getWebPath(String webId) {
        String webPath;
        CharSequence workingPath;
        int factor;
        String[] splittedPath;
        if (StringUtils.isBlank((String)webId)) {
            return null;
        }
        String path = this.webIds.get(webId);
        if (path == null) {
            return null;
        }
        Symlink symlink = null;
        if (!path.startsWith(this.basePath)) {
            for (Symlink link : this.symlinks) {
                if (!path.startsWith(link.getTargetPath())) continue;
                symlink = link;
                break;
            }
        }
        if (symlink == null) {
            splittedPath = StringUtils.split((String)path, (String)"/");
        } else {
            String lookupPath = symlink.getVirtualPath() + StringUtils.substringAfter((String)path, (String)symlink.getTargetPath());
            splittedPath = StringUtils.split((String)lookupPath, (String)"/");
        }
        String closestWebPath = null;
        for (factor = splittedPath.length; factor > 0; --factor) {
            String webPath2;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < factor; ++i) {
                builder.append("/");
                builder.append(splittedPath[i]);
            }
            workingPath = builder.toString();
            if (!((String)workingPath).startsWith(this.basePath) || ((String)workingPath).equals(this.basePath)) break;
            PathValues workingPathValues = this.paths.get(workingPath);
            if (workingPathValues == null || workingPathValues.webId == null || (webPath2 = this.toWebPaths.get(workingPathValues.webId)) == null || webPath2.startsWith(WEB_ID_PATH_PREFIX)) continue;
            closestWebPath = webPath2;
            break;
        }
        StringBuilder workingWebPath = new StringBuilder();
        if (closestWebPath != null) {
            workingWebPath.append(closestWebPath);
        }
        workingPath = new StringBuilder();
        for (int i = 0; i < factor; ++i) {
            ((StringBuilder)workingPath).append("/");
            ((StringBuilder)workingPath).append(splittedPath[i]);
        }
        boolean incompleteWebPath = !StringUtils.startsWith((String)((StringBuilder)workingPath).toString(), (String)this.basePath);
        for (int i = factor; i < splittedPath.length; ++i) {
            PathValues currentPathValues;
            ((StringBuilder)workingPath).append("/");
            ((StringBuilder)workingPath).append(splittedPath[i]);
            String currentPath = ((StringBuilder)workingPath).toString();
            if (symlink != null && !currentPath.equals(symlink.getVirtualPath()) && currentPath.startsWith(symlink.getVirtualPath())) {
                currentPath = symlink.getTargetPath() + StringUtils.substringAfter((String)currentPath, (String)symlink.getVirtualPath());
            }
            if ((currentPathValues = this.paths.get(currentPath)) != null && StringUtils.isNotBlank((String)currentPathValues.segment)) {
                workingWebPath.append("/");
                workingWebPath.append(currentPathValues.segment);
                String currentWebPath = workingWebPath.toString();
                if (currentPathValues.webId == null) continue;
                this.toWebPaths.put(currentPathValues.webId, currentWebPath);
                this.fromWebPaths.put(currentWebPath, currentPathValues.webId);
                continue;
            }
            incompleteWebPath = true;
            break;
        }
        if (incompleteWebPath) {
            workingWebPath.append(WEB_ID_PATH_PREFIX);
            workingWebPath.append(webId);
            webPath = workingWebPath.toString();
        } else {
            webPath = workingWebPath.toString();
        }
        this.toWebPaths.put(webId, webPath);
        this.fromWebPaths.put(webPath, webId);
        return webPath;
    }

    public String getWebId(String webPath) {
        CharSequence workingWebPath;
        int factor;
        if ("".equals(webPath) || StringUtils.equals((String)"/", (String)webPath)) {
            PathValues pathValues = this.paths.get(this.basePath);
            String webId = null;
            if (pathValues != null) {
                webId = pathValues.webId;
            }
            return webId;
        }
        if (StringUtils.isBlank((String)webPath)) {
            return null;
        }
        String webId = this.fromWebPaths.get(webPath);
        if (webId != null) {
            return webId;
        }
        String[] splittedWebPath = StringUtils.split((String)webPath, (String)"/");
        String closestWebId = null;
        for (factor = splittedWebPath.length; factor > 1; --factor) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < factor; ++i) {
                builder.append("/");
                builder.append(splittedWebPath[i]);
            }
            workingWebPath = builder.toString();
            closestWebId = this.fromWebPaths.get(workingWebPath);
            if (closestWebId != null) break;
        }
        String closestPath = null;
        if (closestWebId != null) {
            closestPath = this.webIds.get(closestWebId);
        }
        if (closestPath == null) {
            factor = 0;
        }
        workingWebPath = new StringBuilder();
        for (int i = 0; i < factor; ++i) {
            ((StringBuilder)workingWebPath).append("/");
            ((StringBuilder)workingWebPath).append(splittedWebPath[i]);
        }
        String path = closestPath != null ? closestPath : this.basePath;
        String webId2 = closestWebId;
        for (int i = factor; i < splittedWebPath.length; ++i) {
            String segment = splittedWebPath[i];
            ((StringBuilder)workingWebPath).append("/");
            ((StringBuilder)workingWebPath).append(segment);
            if (segment.startsWith("id_")) {
                webId2 = StringUtils.removeStart((String)segment, (String)"id_");
                if (this.webIds.containsKey(webId2)) {
                    this.fromWebPaths.put(((StringBuilder)workingWebPath).toString(), webId2);
                    break;
                }
                webId2 = null;
                break;
            }
            SegmentKey key = new SegmentKey(path, segment);
            if ((path = this.segments.get(key)) == null) {
                webId2 = null;
                break;
            }
            PathValues pathValues = this.paths.get(path);
            if (pathValues == null || pathValues.webId == null) continue;
            webId2 = pathValues.webId;
            this.fromWebPaths.put(((StringBuilder)workingWebPath).toString(), webId2);
        }
        return webId2;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<EcmDocument> getDocuments() {
        return new ArrayList<Document>(this.documents);
    }

    public List<Symlink> getSymlinks() {
        return this.symlinks;
    }

    public void update(DocumentsMetadata updates) {
        if (CollectionUtils.isNotEmpty((Collection)updates.getDocuments())) {
            this.updateSymlinks(updates);
            for (EcmDocument ecmDocument : updates.getDocuments()) {
                if (!(ecmDocument instanceof Document)) continue;
                Document document = (Document)ecmDocument;
                String webId = document.getString(WEB_ID_PROPERTY);
                String path = StringUtils.removeEnd((String)document.getPath(), (String)".proxy");
                Symlink symlink = null;
                if (!path.startsWith(this.basePath)) {
                    for (Symlink link : this.symlinks) {
                        if (!path.startsWith(link.getTargetPath())) continue;
                        symlink = link;
                        break;
                    }
                }
                String segment = symlink == null ? document.getString(WEB_URL_SEGMENT_PROPERTY) : symlink.getSegment();
                if (!StringUtils.isNotBlank((String)webId)) continue;
                String originalPath = this.webIds.get(webId);
                PathValues originalPathValues = originalPath != null ? this.paths.get(originalPath) : null;
                String originalSegment = originalPathValues != null ? originalPathValues.segment : null;
                if (StringUtils.equals((String)path, (String)originalPath) && StringUtils.equals((String)segment, (String)originalSegment)) continue;
                if (originalPath != null) {
                    for (Map.Entry<String, String> entry : this.webIds.entrySet()) {
                        String currentWebId = entry.getKey();
                        String currentPath = entry.getValue();
                        if (!currentPath.startsWith(originalPath)) continue;
                        this.webIds.put(currentWebId, path + StringUtils.substringAfter((String)currentPath, (String)originalPath));
                        this.toWebPaths.remove(currentWebId);
                    }
                }
                this.webIds.put(webId, path);
                if (originalPath != null) {
                    this.paths.remove(originalPath);
                    for (Map.Entry<String, Object> entry : this.paths.entrySet()) {
                        String currentPath = entry.getKey();
                        if (!currentPath.startsWith(originalPath)) continue;
                        this.paths.remove(currentPath);
                        this.paths.put(path + StringUtils.substringAfter((String)currentPath, (String)originalPath), (PathValues)entry.getValue());
                    }
                }
                this.paths.put(path, new PathValues(webId, segment));
                if (originalPath != null && originalSegment != null) {
                    this.segments.remove(new SegmentKey(StringUtils.substringBeforeLast((String)originalPath, (String)"/"), originalSegment));
                    for (Map.Entry<Object, Object> entry : this.segments.entrySet()) {
                        SegmentKey key = (SegmentKey)entry.getKey();
                        if (!key.parentPath.startsWith(originalPath)) continue;
                        this.segments.put(new SegmentKey(path, key.segment), path + StringUtils.substringAfter((String)((String)entry.getValue()), (String)originalPath));
                    }
                }
                if (!path.equals(this.basePath) && segment != null) {
                    this.segments.put(new SegmentKey(StringUtils.substringBeforeLast((String)path, (String)"/"), segment), path);
                }
                this.toWebPaths.remove(webId);
            }
        }
        this.timestamp = Math.max(this.timestamp, updates.getTimestamp());
    }

    private void updateSymlinks(DocumentsMetadata updates) {
        HashSet<Symlink> originalSymlinks = new HashSet<Symlink>(this.symlinks);
        HashSet<Symlink> removedSymlinks = new HashSet<Symlink>(this.symlinks);
        HashSet<Object> addedSymlinks = new HashSet<Object>();
        for (Object symlink : updates.getSymlinks()) {
            if (originalSymlinks.contains(symlink)) {
                removedSymlinks.remove(symlink);
                continue;
            }
            addedSymlinks.add(symlink);
        }
        HashSet<String> updatedPaths = new HashSet<String>(removedSymlinks.size());
        for (Symlink symlink : removedSymlinks) {
            updatedPaths.add(symlink.getTargetPath());
            this.paths.remove(symlink.getVirtualPath());
            this.segments.remove(new SegmentKey(symlink.getParentPath(), symlink.getSegment()));
        }
        this.symlinks.removeAll(removedSymlinks);
        for (Symlink symlink : addedSymlinks) {
            this.paths.put(symlink.getVirtualPath(), new PathValues(symlink.getTargetWebId(), symlink.getSegment()));
            this.segments.put(new SegmentKey(symlink.getParentPath(), symlink.getSegment()), symlink.getTargetPath());
        }
        this.symlinks.addAll(addedSymlinks);
        if (CollectionUtils.isNotEmpty(updatedPaths)) {
            String[] prefixes = updatedPaths.toArray(new String[updatedPaths.size()]);
            for (Map.Entry<String, String> entry : this.webIds.entrySet()) {
                String currentWebId = entry.getKey();
                String currentPath = entry.getValue();
                if (!StringUtils.startsWithAny((String)currentPath, (String[])prefixes)) continue;
                this.toWebPaths.remove(currentWebId);
            }
        }
    }

    private class SegmentKey {
        private final String parentPath;
        private final String segment;

        public SegmentKey(String parentPath, String segment) {
            this.parentPath = parentPath;
            this.segment = segment;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.parentPath == null ? 0 : this.parentPath.hashCode());
            result = 31 * result + (this.segment == null ? 0 : this.segment.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SegmentKey other = (SegmentKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.parentPath == null ? other.parentPath != null : !this.parentPath.equals(other.parentPath)) {
                return false;
            }
            return !(this.segment == null ? other.segment != null : !this.segment.equals(other.segment));
        }

        private DocumentsMetadataImpl getOuterType() {
            return DocumentsMetadataImpl.this;
        }
    }

    private class PathValues {
        private final String webId;
        private final String segment;

        public PathValues(String webId, String segment) {
            this.webId = webId;
            this.segment = segment;
        }
    }
}

