/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.repository;

import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.repository.AddRemoteProxyFacetCommand;
import fr.toutatice.portail.cms.nuxeo.repository.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.repository.DocumentFetchPublishedCommand;
import fr.toutatice.portail.cms.nuxeo.repository.DocumentsMetadataCommand;
import fr.toutatice.portail.cms.nuxeo.repository.GetChildrenCommand;
import fr.toutatice.portail.cms.nuxeo.repository.GetParentCommand;
import fr.toutatice.portail.cms.nuxeo.repository.NuxeoNavigationItem;
import fr.toutatice.portail.cms.nuxeo.repository.NuxeoUserStorage;
import fr.toutatice.portail.cms.nuxeo.repository.PublishInfosCommand;
import fr.toutatice.portail.cms.nuxeo.repository.RequestPublishStatus;
import fr.toutatice.portail.cms.producers.test.AdvancedRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.Symlinks;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.UpdateInformations;
import org.osivia.portal.api.cms.UpdateScope;
import org.osivia.portal.api.cms.exception.CMSException;
import org.osivia.portal.api.cms.exception.DocumentNotFoundException;
import org.osivia.portal.api.cms.model.Document;
import org.osivia.portal.api.cms.model.NavigationItem;
import org.osivia.portal.api.cms.model.Profile;
import org.osivia.portal.api.cms.repository.BaseUserRepository;
import org.osivia.portal.api.cms.repository.RepositoryFactory;
import org.osivia.portal.api.cms.repository.UserStorage;
import org.osivia.portal.api.cms.repository.cache.SharedRepository;
import org.osivia.portal.api.cms.repository.cache.SharedRepositoryKey;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;
import org.osivia.portal.api.cms.service.GetChildrenRequest;
import org.osivia.portal.api.cms.service.Request;
import org.osivia.portal.api.cms.service.Result;
import org.osivia.portal.api.cms.service.SpaceCacheBean;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.DocumentsMetadata;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.portal.core.cms.spi.NuxeoRepository;
import org.osivia.portal.core.cms.spi.NuxeoRequest;

public class NuxeoRepositoryImpl
extends BaseUserRepository
implements NuxeoRepository,
AdvancedRepository {
    private INuxeoService nuxeoService;
    public static final String RPXY_WID_MARKER = "_c_";
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private static final Log LOG = LogFactory.getLog(NuxeoRepositoryImpl.class);
    private static DocumentsMetadata cacheMetadatas = null;
    private static Long cacheTs = null;

    private INuxeoService getNuxeoService() {
        if (this.nuxeoService == null) {
            this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        }
        return this.nuxeoService;
    }

    public NuxeoUserStorage getUserStorage() {
        return (NuxeoUserStorage)super.getUserStorage();
    }

    public NuxeoRepositoryImpl(RepositoryFactory repositoryFactory, SharedRepositoryKey repositoryKey, BaseUserRepository publishRepository, String userName) {
        super(repositoryFactory, repositoryKey, publishRepository, userName, (UserStorage)new NuxeoUserStorage());
    }

    public Result executeRequest(Request request) throws CMSException {
        if (request instanceof NuxeoRequest) {
            return ((NuxeoUserStorage)super.getUserStorage()).executeCommand(((NuxeoRequest)request).getCommandContext(), ((NuxeoRequest)request).getCommand());
        }
        if (request instanceof GetChildrenRequest) {
            Document parent = this.getDocument(((GetChildrenRequest)request).getParentId().getInternalID());
            org.nuxeo.ecm.automation.client.model.Document nuxeoDoc = (org.nuxeo.ecm.automation.client.model.Document)parent.getNativeItem();
            return ((NuxeoUserStorage)super.getUserStorage()).executeCommand(new GetChildrenCommand(nuxeoDoc.getId()));
        }
        throw new CMSException((Throwable)new IllegalArgumentException("Request not implemented"));
    }

    public boolean supportPreview() {
        return true;
    }

    protected void initDocuments() {
    }

    private NuxeoCommandContext createCommandContext(boolean cache) {
        NuxeoCommandContext commandCtx = null;
        PortletContext cmsPortletContext = this.getNuxeoService().getCMSCustomizer().getPortletContext();
        commandCtx = new NuxeoCommandContext(cmsPortletContext);
        commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        if (cache) {
            commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        } else {
            commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        }
        return commandCtx;
    }

    private NuxeoCommandContext createCommandContext() {
        return this.createCommandContext(true);
    }

    private synchronized DocumentsMetadata getCacheMetaDataCommunityPrototype(String parentWebId) throws CMSException {
        block8: {
            CMSServiceCtx cmsContext = this.getNavigationCMSContext();
            try {
                SpaceCacheBean spaceCacheInformations = this.getSpaceCacheInformations(parentWebId);
                if (cacheTs != null && (spaceCacheInformations == null || spaceCacheInformations.getLastSpaceModification() == null || spaceCacheInformations.getLastSpaceModification() <= cacheTs) && cacheTs + SharedRepository.DOCUMENT_RELOAD_TIMEOUT >= System.currentTimeMillis()) break block8;
                Symlinks symLinks = new Symlinks();
                symLinks.setLinks(new ArrayList());
                DocumentsMetadataCommand command = new DocumentsMetadataCommand("/default-domain/communaute", RequestPublishStatus.published, symLinks, null);
                String savedScope = cmsContext.getScope();
                cmsContext.setScope("superuser_no_cache");
                try {
                    cacheMetadatas = (DocumentsMetadata)((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(false), command).getResult();
                }
                catch (CMSException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CMSException((Throwable)e);
                }
                finally {
                    cmsContext.setScope(savedScope);
                }
                cacheTs = System.currentTimeMillis();
            }
            catch (Exception e) {
                throw new CMSException((Throwable)e);
            }
        }
        return cacheMetadatas;
    }

    public String getInternalId(String path) throws CMSException {
        org.nuxeo.ecm.automation.client.model.Document nxDocument = null;
        String parentWebId = null;
        if (path.startsWith("/default-domain/communaute/")) {
            try {
                CMSServiceCtx cmsContext = this.getNavigationCMSContext();
                CMSItem spaceConfig = this.cmsServiceLocator.getCMSService().getSpaceConfig(cmsContext, "/default-domain/communaute");
                parentWebId = spaceConfig.getWebId();
                DocumentsMetadata metadatas = this.getCacheMetaDataCommunityPrototype(parentWebId);
                nxDocument = null;
                for (EcmDocument ecmDocument : metadatas.getDocuments()) {
                    org.nuxeo.ecm.automation.client.model.Document iterDoc = (org.nuxeo.ecm.automation.client.model.Document)ecmDocument;
                    if (!iterDoc.getPath().equals(path)) continue;
                    if (!iterDoc.getFacets().list().contains("isRemoteProxy") && !iterDoc.getPath().endsWith(".proxy")) {
                        ((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(false), new AddRemoteProxyFacetCommand(path)).getResult();
                        this.notifyUpdate(new UpdateInformations(new UniversalID("nx", iterDoc.getString("ttc:webid")), new UniversalID("nx", parentWebId), UpdateScope.SCOPE_SPACE, false));
                        NuxeoCommandContext ctx = this.createCommandContext(false);
                        ctx.setForceReload(true);
                        iterDoc = (org.nuxeo.ecm.automation.client.model.Document)((NuxeoUserStorage)super.getUserStorage()).executeCommand(ctx, new DocumentFetchPublishedCommand(path)).getResult();
                    }
                    nxDocument = iterDoc;
                    break;
                }
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw new CMSException((Throwable)e);
            }
            if (nxDocument == null) {
                LOG.warn((Object)("Document with path " + path + " has not been found. Maybe cache is not refreshed"));
            }
        }
        if (nxDocument == null) {
            CMSPublicationInfos res = (CMSPublicationInfos)((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(), new PublishInfosCommand(path)).getResult();
            List errors = res.getErrorCodes();
            if (errors != null && errors.contains(1)) {
                throw new DocumentNotFoundException();
            }
            nxDocument = !res.isPublished() ? (org.nuxeo.ecm.automation.client.model.Document)((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(), new DocumentFetchLiveCommand(res.getDocumentPath(), "Read")).getResult() : (org.nuxeo.ecm.automation.client.model.Document)((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(), new DocumentFetchPublishedCommand(res.getDocumentPath())).getResult();
        }
        String internalId = nxDocument.getString("ttc:webid");
        if (nxDocument.getFacets().list().contains("isRemoteProxy")) {
            if (parentWebId == null) {
                org.nuxeo.ecm.automation.client.model.Document parent = (org.nuxeo.ecm.automation.client.model.Document)((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(), new GetParentCommand(nxDocument)).getResult();
                parentWebId = parent.getString("ttc:webid");
            }
            internalId = internalId + RPXY_WID_MARKER + parentWebId;
        }
        return internalId;
    }

    public String getPath(String internalId) throws CMSException {
        CMSPublicationInfos res = (CMSPublicationInfos)((NuxeoUserStorage)super.getUserStorage()).executeCommand(this.createCommandContext(), new PublishInfosCommand("webId:" + internalId)).getResult();
        return res.getDocumentPath();
    }

    private CMSServiceCtx getNavigationCMSContext() {
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(this.getPortalContext());
        if (this.isPreviewRepository()) {
            cmsContext.setDisplayLiveVersion("1");
        }
        return cmsContext;
    }

    public NavigationItem getNavigationItem(String internalId) throws CMSException {
        NuxeoNavigationItem navItem;
        Document doc = this.getDocument(internalId);
        String spacePath = this.getPath(doc.getSpaceId().getInternalID());
        String docPath = this.getPath(internalId);
        CMSServiceCtx cmsContext = this.getNavigationCMSContext();
        CMSItem parent = null;
        String pathToCheck = docPath;
        while (pathToCheck.contains(spacePath)) {
            try {
                parent = this.cmsServiceLocator.getCMSService().getPortalNavigationItem(cmsContext, spacePath, pathToCheck);
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw new CMSException((Throwable)e);
            }
            if (parent != null) break;
            CMSObjectPath parentPath = CMSObjectPath.parse((String)pathToCheck).getParent();
            pathToCheck = parentPath.toString();
        }
        if (parent != null) {
            navItem = new NuxeoNavigationItem(this, new UniversalID(this.getRepositoryName(), parent.getWebId()), (String)parent.getProperties().get("title"), doc.getSpaceId(), spacePath, parent.getPath());
            String pageTemplate = (String)parent.getProperties().get("pageTemplate");
            if (pageTemplate != null && pageTemplate.startsWith("/")) {
                String[] items = pageTemplate.substring(1).split("/");
                String internalID = "";
                for (int i = 0; i < items.length; ++i) {
                    if (internalID.length() > 0) {
                        internalID = internalID + "_";
                    }
                    internalID = internalID + items[i].toUpperCase();
                }
                navItem.setCustomizedTemplateId(new UniversalID(System.getProperty("osivia.cms.template.repository"), internalID));
            }
        } else {
            navItem = null;
        }
        return navItem;
    }

    public NavigationItem computeParentNavigationItem(String spacePath, String docPath, String spaceId) throws CMSException {
        CMSObjectPath parentPath;
        CMSServiceCtx cmsContext = this.getNavigationCMSContext();
        String pathToCheck = docPath;
        CMSItem parent = null;
        while ((pathToCheck = (parentPath = CMSObjectPath.parse((String)pathToCheck).getParent()).toString()).contains(spacePath)) {
            try {
                parent = this.cmsServiceLocator.getCMSService().getPortalNavigationItem(cmsContext, spacePath, pathToCheck);
            }
            catch (org.osivia.portal.core.cms.CMSException e) {
                throw new CMSException((Throwable)e);
            }
            if (parent == null) continue;
            break;
        }
        return new NuxeoNavigationItem(this, new UniversalID(this.getRepositoryName(), parent.getWebId()), (String)parent.getProperties().get("title"), new UniversalID(this.getRepositoryName(), spaceId), spacePath, parent.getPath());
    }

    public List<NavigationItem> computeChildrenNavigationItem(String spacePath, String docPath, String spaceId) throws CMSException {
        CMSServiceCtx cmsContext = this.getNavigationCMSContext();
        ArrayList<NavigationItem> navChildren = new ArrayList<NavigationItem>();
        try {
            List cmsChildren = this.cmsServiceLocator.getCMSService().getPortalNavigationSubitems(cmsContext, spacePath, docPath);
            for (CMSItem child : cmsChildren) {
                navChildren.add(new NuxeoNavigationItem(this, new UniversalID(this.getRepositoryName(), child.getWebId()), (String)child.getProperties().get("title"), new UniversalID(this.getRepositoryName(), spaceId), spacePath, child.getPath()));
            }
        }
        catch (org.osivia.portal.core.cms.CMSException e) {
            throw new CMSException((Throwable)e);
        }
        return navChildren;
    }

    public void publish(String id) throws CMSException {
    }

    public void addWindow(String id, String name, String portletName, String region, int position, String pageId, Map<String, String> properties) throws CMSException {
    }

    public void addDocument(String id, String type, String name, String parentId) throws CMSException {
        this.getUserStorage().addDocument(id, type, name, this.batchMode);
        if (!this.batchMode) {
            RepositoryDocument doc = (RepositoryDocument)this.getDocument(id);
            UpdateInformations infos = new UpdateInformations(new UniversalID(this.getRepositoryName(), id), doc.getSpaceId(), UpdateScope.SCOPE_SPACE, false);
            this.getSharedRepository().notifyUpdate((UserStorage)this.getUserStorage(), infos);
        }
    }

    public void unpublish(String id) throws CMSException {
    }

    public boolean supportPageEdition() {
        return false;
    }

    public List<Document> getChildren(String id) throws CMSException {
        return null;
    }

    public void setACL(String id, List<String> acls) throws CMSException {
    }

    public List<String> getACL(String id) throws CMSException {
        return null;
    }

    public void deleteDocument(String id) throws CMSException {
    }

    public void renameDocument(String id, String title) throws CMSException {
    }

    public void moveDocument(String srcId, String beforedestId, boolean endOfList) throws CMSException {
    }

    public void reloadDatas() {
    }

    public void addDocument(String internalID, RepositoryDocument document) throws CMSException {
    }

    public void updateDocument(String internalID, RepositoryDocument document) throws CMSException {
        this.getUserStorage().updateDocument(internalID, document, this.batchMode);
        if (!this.batchMode) {
            UpdateInformations infos = new UpdateInformations(new UniversalID(this.getRepositoryName(), internalID), document.getSpaceId(), UpdateScope.SCOPE_SPACE, false);
            this.getSharedRepository().notifyUpdate((UserStorage)this.getUserStorage(), infos);
        }
    }

    public void setNewId(String internalID, String newId) throws CMSException {
    }

    public void setProfiles(String id, List<Profile> profiles) throws CMSException {
    }

    public void setStyles(String id, List<String> styles) throws CMSException {
    }

    public void setTemplateId(String id, UniversalID templateID) throws CMSException {
        RepositoryDocument doc = (RepositoryDocument)this.getDocument(id);
        if (templateID != null) {
            doc.getProperties().put("ttc:pageTemplate", templateID.toString());
        } else {
            doc.getProperties().remove("ttc:pageTemplate");
        }
        this.updateDocument(id, doc);
    }
}

