/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandServiceFactory;
import fr.toutatice.portail.cms.nuxeo.repository.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.repository.DocumentFetchPublishedCommand;
import fr.toutatice.portail.cms.nuxeo.repository.PublishInfosCommand;
import fr.toutatice.portail.cms.nuxeo.repository.PublishSpaceCreationCommand;
import fr.toutatice.portail.cms.nuxeo.repository.UpdateDocumentCommand;
import java.util.HashMap;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.cms.UniversalID;
import org.osivia.portal.api.cms.exception.DocumentForbiddenException;
import org.osivia.portal.api.cms.exception.DocumentNotFoundException;
import org.osivia.portal.api.cms.repository.BaseUserRepository;
import org.osivia.portal.api.cms.repository.BaseUserStorage;
import org.osivia.portal.api.cms.repository.UserData;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;
import org.osivia.portal.api.cms.repository.model.shared.RepositorySpace;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.Satellite;
import org.osivia.portal.core.cms.spi.NuxeoResult;

public class NuxeoUserStorage
extends BaseUserStorage {
    private INuxeoService nuxeoService;
    private INuxeoCommandService nuxeoCommandService;

    private INuxeoService getNuxeoService() {
        if (this.nuxeoService == null) {
            this.nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
        }
        return this.nuxeoService;
    }

    public INuxeoCommandService getNuxeoCommandService() throws Exception {
        if (this.nuxeoCommandService == null) {
            this.nuxeoCommandService = NuxeoCommandServiceFactory.getNuxeoCommandService((PortletContext)this.getNuxeoService().getCMSCustomizer().getPortletContext());
        }
        return this.nuxeoCommandService;
    }

    private NuxeoCommandContext createCommandContext(boolean superUser, boolean cache) {
        NuxeoCommandContext commandCtx = null;
        PortletContext cmsPortletContext = this.getNuxeoService().getCMSCustomizer().getPortletContext();
        if (this.getUserRepository().getPortalContext() != null) {
            commandCtx = new NuxeoCommandContext(cmsPortletContext, this.getUserRepository().getPortalContext());
        }
        if (commandCtx == null) {
            commandCtx = new NuxeoCommandContext(cmsPortletContext);
        }
        if (!cache) {
            commandCtx.setForceReload(true);
        }
        if (BaseUserRepository.SUPERUSER_NAME.equals(this.getUserRepository().getUserName())) {
            superUser = true;
        }
        if (superUser) {
            commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            if (cache) {
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            } else {
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            }
        } else {
            commandCtx.setAuthType(NuxeoCommandContext.AUTH_TYPE_USER);
            if (cache) {
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_SESSION);
            } else {
                commandCtx.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
            }
        }
        return commandCtx;
    }

    private NuxeoCommandContext createCommandContext(boolean superUser) {
        return this.createCommandContext(superUser, false);
    }

    public RepositoryDocument reloadDocument(String internalID) throws org.osivia.portal.api.cms.exception.CMSException {
        try {
            RepositoryDocument document;
            CMSPublicationInfos docPubInfos = (CMSPublicationInfos)this.executeCommand(this.createCommandContext(true), new PublishInfosCommand("webId:" + internalID)).getResult();
            boolean getPublishedVersion = this.getUserRepository().isPreviewRepository() ? false : docPubInfos.isPublished();
            Document nxDocument = this.fetchDocument(docPubInfos.getDocumentPath(), getPublishedVersion, false);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (String key : nxDocument.getProperties().getKeys()) {
                properties.put(key, nxDocument.getProperties().get(key));
            }
            String spaceId = null;
            if (docPubInfos.getPublishSpacePath() != null) {
                CMSPublicationInfos spacePubInfos = (CMSPublicationInfos)this.executeCommand(this.createCommandContext(true, true), new PublishInfosCommand(docPubInfos.getPublishSpacePath())).getResult();
                Document space = this.fetchDocument(docPubInfos.getPublishSpacePath(), spacePubInfos.isPublished(), true);
                spaceId = space.getString("ttc:webid");
            }
            if ("Workspace".equals(nxDocument.getType()) || "PortalSite".equals(nxDocument.getType())) {
                String sTemplate;
                if ("Workspace".equals(nxDocument.getType())) {
                    properties.put("osivia.connect.templated", "false");
                    properties.put("osivia.connect.liveSpace", Boolean.TRUE);
                }
                UniversalID templateID = StringUtils.isNotEmpty((String)(sTemplate = (String)properties.get("ttc:pageTemplate"))) ? new UniversalID(sTemplate) : null;
                document = new RepositorySpace(this.getUserRepository(), (EcmDocument)nxDocument, internalID, nxDocument.getPath().substring(nxDocument.getPath().lastIndexOf(47) + 1), null, internalID, null, properties, templateID);
            } else {
                document = new RepositoryDocument(this.getUserRepository(), (EcmDocument)nxDocument, internalID, nxDocument.getPath().substring(nxDocument.getPath().lastIndexOf(47) + 1), null, spaceId, null, properties);
            }
            return document;
        }
        catch (Exception e) {
            if (!(e instanceof org.osivia.portal.api.cms.exception.CMSException)) {
                throw new org.osivia.portal.api.cms.exception.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.api.cms.exception.CMSException)((Object)e);
        }
    }

    private Document fetchDocument(String path, boolean isPublished, boolean cache) throws org.osivia.portal.api.cms.exception.CMSException {
        Document nxDocument = !isPublished ? (Document)this.executeCommand(this.createCommandContext(true, cache), new DocumentFetchLiveCommand(path, "Read")).getResult() : (Document)this.executeCommand(this.createCommandContext(true, cache), new DocumentFetchPublishedCommand(path)).getResult();
        return nxDocument;
    }

    public UserData getUserData(String internalID) throws org.osivia.portal.api.cms.exception.CMSException {
        CMSPublicationInfos res = null;
        res = (CMSPublicationInfos)this.executeCommand(this.createCommandContext(false, true), new PublishInfosCommand("webId:" + internalID)).getResult();
        res.setSatellite(Satellite.MAIN);
        if (res.getErrorCodes().contains(2)) {
            throw new DocumentForbiddenException();
        }
        return res;
    }

    public NuxeoResult executeCommand(NuxeoCommandContext nuxeoCommandContext, final INuxeoCommand command) throws org.osivia.portal.api.cms.exception.CMSException {
        try {
            Object res = this.getNuxeoCommandService().executeCommand(nuxeoCommandContext, new INuxeoServiceCommand(){

                public String getId() {
                    return command.getId();
                }

                public Object execute(Session nuxeoSession) throws Exception {
                    return command.execute(nuxeoSession);
                }
            });
            return new NuxeoResult(res);
        }
        catch (Exception e) {
            if (e instanceof CMSException) {
                CMSException cmsExc = (CMSException)((Object)e);
                if (cmsExc.getErrorCode() == 3) {
                    throw new DocumentNotFoundException();
                }
                if (cmsExc.getErrorCode() == 1) {
                    throw new DocumentForbiddenException();
                }
            }
            if (!(e instanceof org.osivia.portal.api.cms.exception.CMSException)) {
                throw new org.osivia.portal.api.cms.exception.CMSException((Throwable)e);
            }
            throw (org.osivia.portal.api.cms.exception.CMSException)((Object)e);
        }
    }

    public NuxeoResult executeCommand(INuxeoCommand command) throws org.osivia.portal.api.cms.exception.CMSException {
        return this.executeCommand(this.createCommandContext(false), command);
    }

    public void addDocument(String internalID, String type, String name, boolean batchMode) throws org.osivia.portal.api.cms.exception.CMSException {
        if ("space".equals(type)) {
            this.executeCommand(this.createCommandContext(false, true), new PublishSpaceCreationCommand(internalID)).getResult();
        }
    }

    public void updateDocument(String internalID, RepositoryDocument document, boolean batchMode) throws org.osivia.portal.api.cms.exception.CMSException {
        this.executeCommand(this.createCommandContext(false, true), new UpdateDocumentCommand(document)).getResult();
    }

    public void endBatch() {
    }

    public void beginBatch() {
    }

    public void deleteDocument(String internalID, boolean batchMode) throws org.osivia.portal.api.cms.exception.CMSException {
    }

    public void handleError() {
    }
}

