/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.repository.model.shared.RepositoryDocument;

public class UpdateDocumentCommand
implements INuxeoCommand {
    private RepositoryDocument document;
    private List<String> allowedProperties = Arrays.asList("ttc:pageTemplate");

    public UpdateDocumentCommand(RepositoryDocument document) {
        this.document = document;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document nxDocument = (Document)this.document.getNativeItem();
        PropertyMap modifiedProperties = new PropertyMap();
        ArrayList<String> removedProperties = new ArrayList<String>();
        PropertyMap oldProperties = nxDocument.getProperties();
        Map properties = this.document.getProperties();
        for (String key : properties.keySet()) {
            if (!this.allowedProperties.contains(key) || !(properties.get(key) instanceof String) || oldProperties.get(key) != null && oldProperties.get(key).equals(properties.get(key))) continue;
            modifiedProperties.set(key, (String)properties.get(key));
        }
        for (String key : oldProperties.getKeys()) {
            if (!this.allowedProperties.contains(key) || !(oldProperties.get(key) instanceof String) || modifiedProperties.get(key) != null) continue;
            removedProperties.add(key);
        }
        documentService.update((DocRef)nxDocument, modifiedProperties);
        for (String removedProperty : removedProperties) {
            documentService.removeProperty((DocRef)nxDocument, removedProperty);
        }
        return this.document;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("/");
        builder.append(new Date().getTime());
        builder.append("/");
        builder.append(this.document);
        return builder.toString();
    }
}

