/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.services;

import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.services.TransactionResource;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cache.services.IServiceInvoker;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.log.LoggerMessage;
import org.osivia.portal.api.profiler.IProfilerService;
import org.osivia.portal.api.status.IStatusService;
import org.osivia.portal.api.status.UnavailableServer;
import org.osivia.portal.api.transaction.ITransactionResource;
import org.osivia.portal.api.transaction.ITransactionService;
import org.osivia.portal.core.cms.IContentStreamingSupport;
import org.osivia.portal.core.cms.Satellite;
import org.osivia.portal.core.error.IPortalLogger;

public class NuxeoCommandCacheInvoker
implements IServiceInvoker {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(NuxeoCommandCacheInvoker.class);
    NuxeoCommandContext ctx;
    INuxeoServiceCommand command;
    private long maxIdleTime = 600000L;
    private static Map<Integer, Long> sessionsIdle = new HashMap<Integer, Long>();
    private static Map<String, Object> sessionCreationSynchronizers = new HashMap<String, Object>();
    private static List<Integer> AVERAGE_LIST = new ArrayList<Integer>();
    private static final int AVERAGE_SIZE = 20;

    public NuxeoCommandCacheInvoker(NuxeoCommandContext ctx, INuxeoServiceCommand command) {
        this.command = command;
        this.ctx = ctx;
        if (System.getProperty("nuxeo.connection.maxIdleTime") != null) {
            this.maxIdleTime = Long.parseLong(System.getProperty("nuxeo.connection.maxIdleTime"));
        }
    }

    public static Map<String, Session> getUserSessions(HttpSession session) {
        ConcurrentHashMap sessions = (ConcurrentHashMap)session.getAttribute("nuxeo.sessions");
        if (sessions == null) {
            sessions = new ConcurrentHashMap();
            session.setAttribute("nuxeo.sessions", sessions);
        }
        return sessions;
    }

    private static String getSessionPostName(Satellite satellite) {
        if (satellite == null) {
            satellite = Satellite.MAIN;
        }
        return "." + satellite.getId();
    }

    private String getSessionKey() {
        return this.ctx.getSatellite().getId();
    }

    private String getSessionPrefix() {
        return this.getSessionKey() + ".";
    }

    private static synchronized Object getSessionCreationSynchronizer(PortletContext ctx, String virtualUser, Satellite satellite) {
        String key = "SYNC_" + ctx.hashCode();
        if (virtualUser != null) {
            key = key + "_" + virtualUser;
        }
        if (sessionCreationSynchronizers.get(key = key + NuxeoCommandCacheInvoker.getSessionPostName(satellite)) == null) {
            sessionCreationSynchronizers.put(key, key);
        }
        return sessionCreationSynchronizers.get(key);
    }

    public IStatusService getServiceStatut(NuxeoCommandContext ctx) throws Exception {
        IStatusService serviceStatut = (IStatusService)ctx.getPortletContext().getAttribute("StatusService");
        return serviceStatut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke() throws PortalException {
        try {
            Object res = null;
            boolean error = false;
            String profilerUser = null;
            ArrayList<Session> sessionsProfils = null;
            HttpSession userSession = null;
            Session nuxeoSession = null;
            boolean recyclableSession = true;
            try {
                String virtualUser;
                Object sessionCreationSynchronizer;
                IProfilerService profiler = (IProfilerService)Locator.findMBean(IProfilerService.class, (String)"osivia:service=ProfilerService");
                if (this.ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_USER) {
                    Object nuxeoSrc;
                    Long long1;
                    HttpServletRequest userRequest = null;
                    String userName = null;
                    userRequest = (HttpServletRequest)this.ctx.getRequest();
                    userName = (String)userRequest.getAttribute("osivia.delegation.userName");
                    if (userName == null) {
                        userName = userRequest.getRemoteUser();
                    }
                    userSession = userRequest.getSession();
                    profilerUser = userName;
                    if (profilerUser == null) {
                        profilerUser = "unlogged-user";
                    }
                    try {
                        nuxeoSession = NuxeoCommandCacheInvoker.getUserSessions(userSession).get(this.getSessionKey());
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    if (nuxeoSession != null && (long1 = sessionsIdle.get(nuxeoSession.hashCode())) != null && System.currentTimeMillis() - long1 >= this.maxIdleTime) {
                        String name = "shutdown";
                        nuxeoSrc = "NUXEO/" + this.ctx.getSatellite().getId();
                        profiler.logEvent((String)nuxeoSrc, name, System.currentTimeMillis() - long1, error);
                        nuxeoSession.getClient().shutdown();
                        sessionsIdle.remove(nuxeoSession.hashCode());
                        nuxeoSession = null;
                        NuxeoCommandCacheInvoker.getUserSessions(userSession).remove(this.getSessionKey());
                    }
                    String sessionUserName = (String)userSession.getAttribute("osivia.nuxeoSessionUser" + this.getSessionPrefix());
                    sessionCreationSynchronizer = (String)userSession.getAttribute("osivia.sessionCreationSynchronizer");
                    if (sessionCreationSynchronizer == null) {
                        sessionCreationSynchronizer = "sessionCreationSynchronizer" + this.getSessionPrefix();
                        userSession.setAttribute("osivia.sessionCreationSynchronizer" + this.getSessionPrefix(), sessionCreationSynchronizer);
                    }
                    if (nuxeoSession == null || nuxeoSession != null && userName != null && sessionUserName == null) {
                        nuxeoSrc = sessionCreationSynchronizer;
                        synchronized (nuxeoSrc) {
                            nuxeoSession = NuxeoCommandCacheInvoker.getUserSessions(userSession).get(this.getSessionKey());
                            sessionUserName = (String)userSession.getAttribute("osivia.nuxeoSessionUser" + this.getSessionPrefix());
                            if (nuxeoSession == null || nuxeoSession != null && userName != null && sessionUserName == null) {
                                INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
                                nuxeoSession = nuxeoService.createUserSession(this.ctx.getSatellite(), userName);
                                long start = System.currentTimeMillis();
                                sessionsIdle.put(nuxeoSession.hashCode(), start);
                                NuxeoCommandCacheInvoker.getUserSessions(userSession).put(this.getSessionKey(), nuxeoSession);
                                userSession.setAttribute("osivia.nuxeoProfilerUserSessionTs" + this.getSessionPrefix(), (Object)System.currentTimeMillis());
                                if (userName != null) {
                                    userSession.setAttribute("osivia.nuxeoSessionUser" + this.getSessionPrefix(), (Object)userName);
                                }
                            }
                        }
                    }
                } else {
                    Long long1;
                    PortletContext portletCtx = this.ctx.getPortletContext();
                    String sessionKey = "osivia.nuxeoSession_virtualuser." + this.getSessionPrefix();
                    virtualUser = null;
                    if (this.ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_ANONYMOUS) {
                        sessionKey = sessionKey + "__ANONYMOUS__";
                    } else if (this.ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_PROFIL) {
                        sessionKey = sessionKey + "__PROFIL_" + this.ctx.getAuthProfil().getNuxeoVirtualUser() + "__";
                        virtualUser = this.ctx.getAuthProfil().getNuxeoVirtualUser();
                    } else if (this.ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_SUPERUSER) {
                        sessionKey = sessionKey + "__SUPERUSER__";
                        virtualUser = System.getProperty("nuxeo.superUserId");
                    }
                    profilerUser = virtualUser;
                    if (profilerUser == null) {
                        profilerUser = "vu-anonymous";
                    }
                    sessionCreationSynchronizer = NuxeoCommandCacheInvoker.getSessionCreationSynchronizer(portletCtx, sessionKey, this.ctx.getSatellite());
                    synchronized (sessionCreationSynchronizer) {
                        sessionsProfils = (List)portletCtx.getAttribute(sessionKey);
                        if (sessionsProfils == null) {
                            sessionsProfils = new ArrayList<Session>();
                            portletCtx.setAttribute(sessionKey, sessionsProfils);
                        }
                        if (sessionsProfils.size() > 0) {
                            nuxeoSession = (Session)sessionsProfils.get(0);
                            sessionsProfils.remove(0);
                        }
                    }
                    if (nuxeoSession != null && (long1 = sessionsIdle.get(nuxeoSession.hashCode())) != null && System.currentTimeMillis() - long1 >= this.maxIdleTime) {
                        String name = "shutdown";
                        String nuxeoSrc = "NUXEO/" + this.ctx.getSatellite().getId();
                        profiler.logEvent(nuxeoSrc, name, System.currentTimeMillis() - long1, error);
                        nuxeoSession.getClient().shutdown();
                        sessionsIdle.remove(nuxeoSession.hashCode());
                        nuxeoSession = null;
                    }
                    if (nuxeoSession == null) {
                        INuxeoService nuxeoService = (INuxeoService)Locator.findMBean(INuxeoService.class, (String)"osivia:service=NuxeoService");
                        nuxeoSession = nuxeoService.createUserSession(this.ctx.getSatellite(), virtualUser);
                        long start = System.currentTimeMillis();
                        sessionsIdle.put(nuxeoSession.hashCode(), start);
                    }
                }
                logger.debug((Object)("Execution commande " + this.command.getId()));
                long begin = 0L;
                try {
                    virtualUser = nuxeoSession;
                    synchronized (virtualUser) {
                        Object object;
                        ITransactionService transactionService;
                        begin = System.currentTimeMillis();
                        if (this.ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_USER && (transactionService = (ITransactionService)Locator.findMBean(ITransactionService.class, (String)"osivia:service=TransactionService")).isStarted() && transactionService.getResource("NUXEO") == null && (object = nuxeoSession.newRequest("Repository.StartTransaction").execute()) instanceof FileBlob) {
                            FileBlob txIdAsBlob = (FileBlob)object;
                            String txId = IOUtils.toString((InputStream)txIdAsBlob.getStream(), (String)"UTF-8");
                            transactionService.register("NUXEO", (ITransactionResource)new TransactionResource(this.ctx, txId));
                        }
                        res = this.command.execute(nuxeoSession);
                    }
                }
                catch (Exception e) {
                    if (e.getCause() instanceof IllegalStateException || e.getCause() instanceof SocketTimeoutException) {
                        recyclableSession = false;
                    }
                    error = true;
                    throw e;
                }
                finally {
                    String maxAverageDelay;
                    long end = System.currentTimeMillis();
                    sessionsIdle.put(nuxeoSession.hashCode(), end);
                    long elapsedTime = end - begin;
                    String cmdId = this.command.getId();
                    if (this.command.getId() == null) {
                        cmdId = this.command.toString();
                    }
                    String name = "id='" + cmdId + "',user='" + profilerUser + "'";
                    name = name + ", nuxeoSession=" + nuxeoSession.hashCode();
                    if (this.ctx.getSatellite() == null && (maxAverageDelay = System.getProperty("nuxeo.maxAverageDelayMs")) != null) {
                        long maxDelay = Long.parseLong(maxAverageDelay);
                        if (!error && StringUtils.startsWith((String)this.command.getId(), (String)"PublishInfosCommand")) {
                            List<Integer> list = AVERAGE_LIST;
                            synchronized (list) {
                                while (AVERAGE_LIST.size() >= 20) {
                                    AVERAGE_LIST.remove(0);
                                }
                                if (elapsedTime < 1000L) {
                                    AVERAGE_LIST.add((int)elapsedTime);
                                }
                                if (AVERAGE_LIST.size() == 20) {
                                    long total = 0L;
                                    for (int i = 0; i < AVERAGE_LIST.size(); ++i) {
                                        total += (long)AVERAGE_LIST.get(i).intValue();
                                    }
                                    long moyenne = total / (long)AVERAGE_LIST.size();
                                    if (moyenne > maxDelay) {
                                        String statusMsg = "Floating average time : " + moyenne + "ms";
                                        if (this.getServiceStatut(this.ctx).isReady("NX-OVERLOAD")) {
                                            this.getServiceStatut(this.ctx).notifyError("NX-OVERLOAD", new UnavailableServer("[DOWN]" + statusMsg));
                                        }
                                        AVERAGE_LIST.clear();
                                    } else if (!this.getServiceStatut(this.ctx).isReady("NX-OVERLOAD")) {
                                        String statusMsg = "Floating average time : " + moyenne + "ms";
                                        this.getServiceStatut(this.ctx).notifyError("NX-OVERLOAD", new UnavailableServer("[UP] " + statusMsg));
                                    }
                                }
                            }
                        }
                    }
                    String nuxeoSrc = "NUXEO/" + this.ctx.getSatellite().getId();
                    profiler.logEvent(nuxeoSrc, name, elapsedTime, error);
                    if (IPortalLogger.logger.isDebugEnabled()) {
                        String commandName = "";
                        if (this.command.getId() != null) {
                            commandName = this.command.getId().replaceAll("\"", "'");
                        }
                        if (!error) {
                            IPortalLogger.logger.debug((Object)new LoggerMessage("call to " + nuxeoSrc + " \"" + commandName + "\" " + elapsedTime));
                        } else {
                            IPortalLogger.logger.debug((Object)new LoggerMessage("call to " + nuxeoSrc + " \"" + commandName + "\" " + elapsedTime + " \"an error as occured\""));
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                if (res instanceof IContentStreamingSupport) {
                    IContentStreamingSupport contentStreamingSupport = (IContentStreamingSupport)res;
                    boolean bl = recyclableSession = contentStreamingSupport.getStream() == null;
                }
                if (sessionsProfils != null && recyclableSession) {
                    sessionsProfils.add(nuxeoSession);
                }
                if (userSession != null && !recyclableSession) {
                    NuxeoCommandCacheInvoker.getUserSessions(userSession).remove(this.getSessionKey());
                }
                throw throwable;
            }
            if (res instanceof IContentStreamingSupport) {
                IContentStreamingSupport contentStreamingSupport = (IContentStreamingSupport)res;
                boolean bl = recyclableSession = contentStreamingSupport.getStream() == null;
            }
            if (sessionsProfils != null && recyclableSession) {
                sessionsProfils.add(nuxeoSession);
            }
            if (userSession != null && !recyclableSession) {
                NuxeoCommandCacheInvoker.getUserSessions(userSession).remove(this.getSessionKey());
            }
            return res;
        }
        catch (Exception e) {
            throw PortalException.wrap((Exception)e);
        }
    }
}

