/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.services;

import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommandService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoServiceCommand;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoSatelliteConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.services.AsyncCommandBean;
import fr.toutatice.portail.cms.nuxeo.services.AsyncCommandThread;
import fr.toutatice.portail.cms.nuxeo.services.NuxeoCommandCacheInvoker;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.HttpHostConnectException;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.cache.services.ICacheService;
import org.osivia.portal.api.cache.services.IServiceInvoker;
import org.osivia.portal.api.cms.CMSController;
import org.osivia.portal.api.cms.service.CMSService;
import org.osivia.portal.api.cms.service.CMSSession;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.status.IStatusService;
import org.osivia.portal.api.status.UnavailableServer;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.NavigationItem;
import org.osivia.portal.core.cms.Satellite;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.profils.IProfilManager;

public class NuxeoCommandService
implements INuxeoCommandService {
    private static Log log = LogFactory.getLog(NuxeoCommandService.class);
    ExecutorService executor;
    IStatusService serviceStatut = null;
    IProfilManager profilManager = null;
    IPortalUrlFactory portalUrlFactory = null;
    ICacheService serviceCache = null;
    private final Set<AsyncCommandBean> asyncCommands = Collections.synchronizedSet(new HashSet());

    public NuxeoCommandService() throws Exception {
        log.debug((Object)"creating NuxeoCommandService");
        AsyncCommandThread asyncThread = new AsyncCommandThread(this);
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.submit(asyncThread);
    }

    public IPortalUrlFactory getPortalUrlFactory(NuxeoCommandContext ctx) throws Exception {
        if (this.portalUrlFactory == null) {
            this.portalUrlFactory = (IPortalUrlFactory)Locator.getService(IPortalUrlFactory.class);
        }
        return this.portalUrlFactory;
    }

    public IProfilManager getProfilManager(NuxeoCommandContext ctx) throws Exception {
        if (this.profilManager == null) {
            this.profilManager = (IProfilManager)Locator.getService(IProfilManager.class);
        }
        return this.profilManager;
    }

    public IStatusService getServiceStatut(NuxeoCommandContext ctx) throws Exception {
        if (this.serviceStatut == null) {
            this.serviceStatut = (IStatusService)Locator.getService(IStatusService.class);
        }
        return this.serviceStatut;
    }

    public ICacheService getServiceCache(NuxeoCommandContext ctx) throws Exception {
        if (this.serviceCache == null) {
            this.serviceCache = (ICacheService)Locator.getService(ICacheService.class);
        }
        return this.serviceCache;
    }

    protected synchronized void addAsyncronousCommand(NuxeoCommandContext ctx, INuxeoServiceCommand command) {
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_USER) {
            return;
        }
        this.asyncCommands.add(new AsyncCommandBean(ctx, command));
    }

    protected synchronized void removeAsyncronousCommand(AsyncCommandBean command) {
        this.asyncCommands.remove(command);
    }

    protected synchronized List<AsyncCommandBean> getAsyncronousCommands() {
        ArrayList<AsyncCommandBean> commands = new ArrayList<AsyncCommandBean>();
        for (AsyncCommandBean command : this.asyncCommands) {
            commands.add(command);
        }
        return commands;
    }

    private boolean checkScope(NuxeoCommandContext ctx) throws Exception {
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_USER) {
            return true;
        }
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_SUPERUSER) {
            return true;
        }
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_ANONYMOUS) {
            return true;
        }
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_PROFIL) {
            if (ctx.isAdministrator()) {
                return true;
            }
            return this.getProfilManager(ctx).verifierProfilUtilisateur(ctx.getAuthProfil().getName());
        }
        return false;
    }

    private String getCacheId(NuxeoCommandContext ctx, INuxeoServiceCommand command) {
        String cacheId = command.getId();
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_ANONYMOUS) {
            cacheId = "anonymous/" + command.getId();
        }
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_PROFIL) {
            cacheId = ctx.getAuthProfil().getName() + "/" + command.getId();
        }
        cacheId = ctx.getSatellite().getId() + "/" + cacheId;
        return cacheId;
    }

    private Object invokeViaCache(NuxeoCommandContext ctx, INuxeoServiceCommand command) throws Exception {
        NuxeoCommandCacheInvoker nuxeoInvoker = new NuxeoCommandCacheInvoker(ctx, command);
        Map requestCache = PageProperties.getProperties().getPageRequestCache();
        String requestKey = "" + ctx.getAuthType();
        if (ctx.getAuthType() == NuxeoCommandContext.AUTH_TYPE_PROFIL) {
            requestKey = requestKey + ctx.getAuthProfil().getName();
        }
        requestKey = requestKey + ctx.getSatellite().getId() + "/" + command.getId();
        if (!ctx.isForceReload()) {
            Object value;
            if (requestCache != null && (value = requestCache.get(requestKey)) != null) {
                Long tsRefresh;
                if (PageProperties.getProperties().isRefreshingPage() && requestCache.get(requestKey + ".resfreshed") == null) {
                    requestCache.put(requestKey + ".resfreshed", "1");
                    value = null;
                }
                if (PageProperties.getProperties().isCheckingSpaceContents() && ((tsRefresh = (Long)requestCache.get(requestKey + ".spaceRefreshed")) == null || tsRefresh < PageProperties.getProperties().getCheckingSpaceBeginning())) {
                    requestCache.put(requestKey + ".spaceRefreshed", System.currentTimeMillis());
                    value = null;
                }
                if (value != null) {
                    return value;
                }
            }
            if (ctx.getCacheType() == CacheInfo.CACHE_SCOPE_NONE) {
                return nuxeoInvoker.invoke();
            }
            if (ctx.getCacheTimeOut() == 0L) {
                return nuxeoInvoker.invoke();
            }
        }
        String cacheId = this.getCacheId(ctx, command);
        CacheInfo cacheInfos = new CacheInfo(cacheId, ctx.getCacheType(), (IServiceInvoker)nuxeoInvoker, ctx.getRequest(), ctx.getPortletContext(), ctx.isAsyncCacheRefreshing());
        if (!ctx.isForceReload()) {
            if (PageProperties.getProperties().isCheckingSpaceContents()) {
                PortalControllerContext portalCtx = new PortalControllerContext(ctx.getPortletContext());
                CMSController ctrl = new CMSController(portalCtx);
                CMSSession session = ((CMSService)Locator.getService(CMSService.class)).getCMSSession(ctrl.getCMSContext());
                Long modifiedTs = PageProperties.getProperties().getCheckingSpaceTs();
                if (modifiedTs != null) {
                    cacheInfos.setExpirationTs(modifiedTs);
                }
            }
            if (ctx.getCacheType() == CacheInfo.CACHE_SCOPE_PORTLET_SESSION) {
                cacheInfos.setExpirationDelay(120000L);
            } else if (ctx.getCacheTimeOut() == -1L) {
                if (System.getProperty("nuxeo.cacheTimeout") != null) {
                    cacheInfos.setExpirationDelay(Long.parseLong(System.getProperty("nuxeo.cacheTimeout")) * 1000L);
                } else {
                    cacheInfos.setExpirationDelay(0L);
                }
            } else {
                cacheInfos.setExpirationDelay(ctx.getCacheTimeOut());
            }
        } else {
            cacheInfos.setForceReload(true);
        }
        Object response = this.getServiceCache(ctx).getCache(cacheInfos);
        if (requestCache != null) {
            boolean navigationItems = false;
            if (response instanceof HashMap) {
                navigationItems = true;
                for (Object item : ((Map)response).values()) {
                    if (item instanceof NavigationItem) continue;
                    navigationItems = false;
                }
            }
            if (response instanceof Document || response instanceof CMSPublicationInfos || navigationItems) {
                requestCache.put(requestKey, response);
            }
        }
        return response;
    }

    private Object getCachedValue(NuxeoCommandContext ctx, INuxeoServiceCommand command) throws Exception {
        NuxeoCommandCacheInvoker nuxeoInvoker = new NuxeoCommandCacheInvoker(ctx, command);
        if (ctx.getCacheType() == CacheInfo.CACHE_SCOPE_NONE) {
            return null;
        }
        String cacheId = this.getCacheId(ctx, command);
        CacheInfo cacheInfos = new CacheInfo(cacheId, ctx.getCacheType(), (IServiceInvoker)nuxeoInvoker, ctx.getRequest(), ctx.getPortletContext(), ctx.isAsyncCacheRefreshing());
        cacheInfos.setForceNOTReload(true);
        return this.getServiceCache(ctx).getCache(cacheInfos);
    }

    protected boolean checkStatus(NuxeoCommandContext ctx) throws Exception {
        return this.getServiceStatut(ctx).isReady(NuxeoSatelliteConnectionProperties.getConnectionProperties((Satellite)ctx.getSatellite()).getPrivateBaseUri().toString());
    }

    protected void handleError(NuxeoCommandContext ctx, String commandId, Exception e) throws CMSException {
        try {
            Throwable cause;
            if (e instanceof RemoteException) {
                RemoteException re = (RemoteException)e;
                if (re.getStatus() == 404) {
                    throw new CMSException(3);
                }
                if (re.getStatus() == 401 || re.getStatus() == 403) {
                    throw new CMSException(1);
                }
                if (re.getStatus() == 500) {
                    this.getServiceStatut(ctx).markServiceToCheck(NuxeoConnectionProperties.getPrivateBaseUri().toString());
                } else {
                    this.getServiceStatut(ctx).notifyError(NuxeoSatelliteConnectionProperties.getConnectionProperties((Satellite)ctx.getSatellite()).getPrivateBaseUri().toString(), new UnavailableServer(e.getMessage()));
                }
            } else if (e instanceof RuntimeException && ((cause = e.getCause()) instanceof HttpHostConnectException || cause instanceof SocketTimeoutException || cause instanceof UnknownHostException)) {
                this.getServiceStatut(ctx).notifyError(NuxeoSatelliteConnectionProperties.getConnectionProperties((Satellite)ctx.getSatellite()).getPrivateBaseUri().toString(), new UnavailableServer(e.getMessage()));
            }
            throw e;
        }
        catch (Exception e2) {
            CMSException exc = null;
            exc = !(e2 instanceof CMSException) ? new CMSException((Throwable)e2) : (CMSException)e2;
            exc.setSatellite(ctx.getSatellite());
            exc.setCommandId(commandId);
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(NuxeoCommandContext ctx, INuxeoServiceCommand command) throws Exception {
        block12: {
            try {
                if (ctx.isAsynchronousCommand()) {
                    this.addAsyncronousCommand(ctx, command);
                    break block12;
                }
                Object resp = null;
                if (!this.checkScope(ctx)) {
                    throw new CMSException(1);
                }
                if (!this.checkStatus(ctx)) {
                    Object cachedValue = this.getCachedValue(ctx, command);
                    if (cachedValue != null) {
                        resp = cachedValue;
                    } else {
                        throw new CMSException(2);
                    }
                }
                if (resp == null) {
                    resp = this.invokeViaCache(ctx, command);
                }
                Object object = resp;
                return object;
            }
            catch (Exception e) {
                this.handleError(ctx, command.getId(), e);
            }
            finally {
                if (ctx.isAsynchronousUpdates()) {
                    this.addAsyncronousCommand(ctx, command);
                }
            }
        }
        return null;
    }

    public void destroy() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }
}

