/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.kernel.tomcat;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.commons.lang3.StringUtils;

public class OrderedContextComparator
implements Comparator<Object> {
    private List<String> orderedContexts = null;
    private final String prefix;
    private final String suffix;

    public OrderedContextComparator(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    private List<String> getOrdererContexts() {
        if (this.orderedContexts == null) {
            this.orderedContexts = new ArrayList<String>();
            String order = System.getProperty("portal.deploy.order");
            if (StringUtils.isNotEmpty((CharSequence)order)) {
                String[] tokens = order.split("\\|");
                for (int i = 0; i < tokens.length; ++i) {
                    this.orderedContexts.add(this.prefix + tokens[i] + this.suffix);
                }
            }
        }
        return this.orderedContexts;
    }

    @Override
    public int compare(Object o1, Object o2) {
        String s1 = o1 instanceof Container ? ((Container)o1).getName() : o1.toString();
        String s2 = o2 instanceof Container ? ((Container)o2).getName() : o2.toString();
        int i1 = this.getOrdererContexts().indexOf(s1);
        int i2 = this.getOrdererContexts().indexOf(s2);
        if (i1 != -1) {
            if (i2 != -1) {
                return i1 - i2;
            }
            return -1;
        }
        if (i2 != -1) {
            return 1;
        }
        return s1.compareTo(s2);
    }
}

