/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.kernel.tomcat;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.jboss.portal.web.command.CommandServlet;
import org.jboss.portal.web.spi.WebAppContext;

public class TomcatWebAppContext
implements WebAppContext {
    private final Context context;
    private final ServletContext servletContext;
    private final ClassLoader classLoader;
    private final String contextPath;
    private Wrapper commandServlet;

    public TomcatWebAppContext(Context context) {
        this.context = context;
        this.servletContext = context.getServletContext();
        this.classLoader = context.getLoader().getClassLoader();
        this.contextPath = context.getPath();
    }

    public void start() throws Exception {
        try {
            this.commandServlet = this.context.createWrapper();
            this.commandServlet.setName("JBossServlet");
            this.commandServlet.setLoadOnStartup(0);
            this.commandServlet.setServletClass(CommandServlet.class.getName());
            this.context.addChild((Container)this.commandServlet);
            this.context.addServletMapping("/jbossportlet", "JBossServlet");
        }
        catch (Exception e) {
            this.cleanup();
            throw e;
        }
    }

    public void stop() {
        this.cleanup();
    }

    private void cleanup() {
        if (this.commandServlet != null) {
            try {
                this.context.removeServletMapping("jbossportlet");
                this.context.removeChild((Container)this.commandServlet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean importFile(String parentDirRelativePath, String name, InputStream source, boolean overwrite) throws IOException {
        return false;
    }
}

