/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api.discussions;

import java.util.HashMap;
import javax.servlet.http.HttpSession;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.urls.IPortalUrlFactory;

public class DiscussionHelper {
    public static String ATTR_LOCAL_PUBLICATION_CACHE = "osivia.cms.discussions.publication.infos";
    private static IPortalUrlFactory portalUrlFactory;
    private static IBundleFactory bundleFactory;

    private static IPortalUrlFactory getUrlFactory() {
        if (portalUrlFactory == null) {
            portalUrlFactory = (IPortalUrlFactory)Locator.getService(IPortalUrlFactory.class);
        }
        return portalUrlFactory;
    }

    private static String getDiscussionUrl(PortalControllerContext portalControllerContext, String id, String participant, String publicationId, String messageId, String mode) {
        String url;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.hideTitle", "1");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("view", "detail");
        if (id != null) {
            params.put("id", id);
        }
        if (participant != null) {
            params.put("participant", participant);
        }
        if (publicationId != null) {
            params.put("publicationId", publicationId);
        }
        if (messageId != null) {
            params.put("messageId", messageId);
        }
        if (mode != null) {
            params.put("mode", mode);
        }
        try {
            url = DiscussionHelper.getUrlFactory().getStartPortletInNewPage(portalControllerContext, "discussion", "Discussion", "index-cloud-ens-discussion-instance", properties, params);
        }
        catch (PortalException e) {
            url = "#";
        }
        return url;
    }

    public static String getDiscussionUrlByParticipant(PortalControllerContext portalControllerContext, String participant, String publicationId) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, null, participant, publicationId, null, null);
    }

    public static String getDiscussionUrlByPublication(PortalControllerContext portalControllerContext, String publicationId) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, null, null, publicationId, null, null);
    }

    public static String getDiscussionUrlById(PortalControllerContext portalControllerContext, String id) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, id, null, null, null, null);
    }

    public static String getDiscussionAdminUrl(PortalControllerContext portalControllerContext, String discussionId, String messageId) {
        return DiscussionHelper.getDiscussionUrl(portalControllerContext, discussionId, null, null, messageId, "admin");
    }

    public static void resetLocalPublications(PortalControllerContext portalControllerContext) {
        HttpSession session = portalControllerContext.getHttpServletRequest().getSession();
        session.removeAttribute(ATTR_LOCAL_PUBLICATION_CACHE);
    }
}

