/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.commands;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSException;

public class DenormalizedDocumentFetchCommand
implements INuxeoCommand {
    private static final String OPERATION_ID = "Document.QueryES";
    private final String path;
    private final int state;

    public DenormalizedDocumentFetchCommand(String path, int state) {
        this.path = path;
        this.state = state;
    }

    public Document execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:path = '").append(this.path).append("' ");
        NuxeoQueryFilterContext queryFilterContext = new NuxeoQueryFilterContext(this.state);
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)queryFilterContext, (String)clause.toString());
        OperationRequest operationRequest = nuxeoSession.newRequest(OPERATION_ID);
        operationRequest.setHeader("X-NXDocumentProperties", "*");
        operationRequest.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        Documents documents = (Documents)operationRequest.execute();
        if (documents == null || documents.isEmpty()) {
            throw new CMSException(3);
        }
        if (documents.size() != 1) {
            throw new CMSException("Too much results.");
        }
        Document document = documents.get(0);
        return document;
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("|");
        builder.append(StringUtils.trimToEmpty((String)this.path));
        builder.append("|");
        builder.append(this.state);
        return builder.toString();
    }
}

