/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class SitePictureFragmentModule
extends FragmentModule {
    public static final String ID = "site_picture";
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String TARGET_PATH_WINDOW_PROPERTY = "osivia.targetPath";
    private static final String ADMIN_JSP_NAME = "site-picture";
    private static final String VIEW_JSP_NAME = "picture";

    public SitePictureFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController(request, response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        String targetPath = window.getProperty(TARGET_PATH_WINDOW_PROPERTY);
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            nuxeoPath = nuxeoController.getComputedPath(nuxeoPath);
            try {
                nuxeoPath = URLEncoder.encode(nuxeoPath, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                request.setAttribute("messageKey", (Object)"ERROR_GENERIC_MESSAGE");
            }
            StringBuilder imageSource = new StringBuilder();
            imageSource.append(request.getContextPath());
            imageSource.append("/sitepicture?path=");
            imageSource.append(nuxeoPath);
            request.setAttribute("imageSource", (Object)imageSource.toString());
            if (targetPath != null) {
                targetPath = nuxeoController.getComputedPath(targetPath);
                Link link = nuxeoController.getCMSLinkByPath(targetPath, null);
                request.setAttribute("link", (Object)link);
            }
        } else {
            request.setAttribute("messageKey", (Object)"MESSAGE_PATH_UNDEFINED");
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        String targetPath = window.getProperty(TARGET_PATH_WINDOW_PROPERTY);
        request.setAttribute("targetPath", (Object)targetPath);
    }

    public void processAction(PortalControllerContext portalControllerContext) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        if ("admin".equals(request.getPortletMode().toString()) && "save".equals(request.getParameter("javax.portlet.action"))) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
            window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("nuxeoPath")));
            window.setProperty(TARGET_PATH_WINDOW_PROPERTY, StringUtils.trimToNull((String)request.getParameter("targetPath")));
        }
    }

    public boolean isDisplayedInAdmin() {
        return true;
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }

    public String getAdminJSPName() {
        return ADMIN_JSP_NAME;
    }
}

