/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.avatar;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.ResourceUtil;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.portlets.document.DocumentFetchLiveCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.FileContentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.GetUserProfileCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.CMSBinaryContent;

public class AvatarServlet
extends HttpServlet {
    protected static final Log logger = LogFactory.getLog(AvatarServlet.class);
    private static final long serialVersionUID = -5291928343907068474L;
    private static PortletContext portletCtx;
    private static final int AVATAR_TIMEOUT = 3600;
    private static final IDirectoryServiceLocator DIRECTORY_SERVICE_LOCATOR;

    public static void setPortletContext(PortletContext documentPortletCtx) {
        portletCtx = documentPortletCtx;
    }

    public String formatResourceLastModified() {
        SimpleDateFormat inputFormater = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        inputFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        return inputFormater.format(new Date(System.currentTimeMillis()));
    }

    public void doGet(HttpServletRequest theRequest, HttpServletResponse theResponse) throws IOException, ServletException {
        ServletOutputStream output = theResponse.getOutputStream();
        try {
            Document fetchedUserProfile;
            Document userProfile;
            DirectoryPerson person;
            String username = theRequest.getParameter("username");
            username = URLDecoder.decode(username, "UTF-8");
            NuxeoController ctx = new NuxeoController(portletCtx);
            ctx.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
            ctx.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
            String userId = null;
            IDirectoryService directoryService = DIRECTORY_SERVICE_LOCATOR.getDirectoryService();
            if (directoryService != null && (person = directoryService.getPerson(username)) != null) {
                userId = person.getUid();
            }
            boolean genericAvatar = true;
            theResponse.setHeader("Cache-Control", "max-age=3600");
            theResponse.setHeader("Last-Modified", this.formatResourceLastModified());
            if (userId != null && (userProfile = (Document)ctx.executeNuxeoCommand((INuxeoCommand)new GetUserProfileCommand(userId))) != null && (fetchedUserProfile = (Document)ctx.executeNuxeoCommand((INuxeoCommand)new DocumentFetchLiveCommand(userProfile.getPath(), "Read"))).getProperties().get("userprofile:avatar") != null) {
                FileContentCommand command = new FileContentCommand(fetchedUserProfile, "userprofile:avatar");
                command.setTimestamp(theRequest.getParameter("t"));
                CMSBinaryContent content = (CMSBinaryContent)ctx.executeNuxeoCommand((INuxeoCommand)command);
                theResponse.setContentType(content.getMimeType());
                ResourceUtil.copy((InputStream)new FileInputStream(content.getFile()), (OutputStream)theResponse.getOutputStream(), (int)4096);
                genericAvatar = false;
            }
            if (genericAvatar) {
                File file = new File(portletCtx.getRealPath("/img/guest.png"));
                byte[] data = FileUtils.readFileToByteArray((File)file);
                theResponse.setContentType("image/png");
                int length = Long.valueOf(file.length()).intValue();
                theResponse.setContentLength(length);
                theResponse.getOutputStream().write(data);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            output.close();
        }
    }

    static {
        DIRECTORY_SERVICE_LOCATOR = (IDirectoryServiceLocator)Locator.findMBean(IDirectoryServiceLocator.class, (String)"osivia:service=DirectoryServiceLocator");
    }
}

