/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.domain.CustomizedJsp;
import fr.toutatice.portail.cms.nuxeo.api.domain.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.IMenubarModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.fragment.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.api.player.INuxeoPlayerModule;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.CommentsFormatter;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.NuxeoCommentsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomizationPluginMgr;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.DefaultPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesLoader;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WysiwygParser;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.XSLFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.ContextDocumentsHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.document.helpers.DocumentHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.DocumentPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.LinkFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.NavigationPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.PropertyFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SitePictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SpaceMenubarFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.service.commands.EraseModificationsCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.LockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnlockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.FragmentEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.HTMLEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.ListEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.PictureEditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.PortletEditableWindow;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceURL;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpSessionEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.cms.impl.BasicPublicationInfos;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.EcmCommonCommands;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.panels.PanelPlayer;
import org.osivia.portal.api.player.Player;
import org.osivia.portal.api.taskbar.TaskbarTask;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSExtendedDocumentInfos;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.customization.ICustomizationService;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.web.IWebIdService;
import org.osivia.portal.core.web.IWebUrlService;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DefaultCMSCustomizer
implements INuxeoCustomizer {
    protected static final Log LOGGER = LogFactory.getLog(DefaultCMSCustomizer.class);
    public static final String DEFAULT_SCHEMAS = "dublincore, common, toutatice, file";
    public static final String TEMPLATE_DOWNLOAD = "download";
    private static final String AVATAR_SERVLET = "/toutatice-portail-cms-nuxeo/avatar?username=";
    private static final String BINARY_SERVLET = "/toutatice-portail-cms-nuxeo/binary";
    private final PortletContext portletCtx;
    private final IPortalUrlFactory portalUrlFactory;
    private final IBundleFactory bundleFactory;
    private UserPagesLoader userPagesLoader;
    private MenuBarFormater menuBarFormater;
    @Deprecated
    private NavigationItemAdapter navigationItemAdapter;
    private NuxeoConnectionProperties nuxeoConnection;
    private XMLReader parser;
    private INuxeoCommentsService commentsService;
    private ClassLoader cl;
    private CMSService cmsService;
    private IWebIdService webIdService;
    private IWebUrlService webUrlService;
    private IDirectoryService directoryService;
    private INotificationsService notificationsService;
    private IInternationalizationService internationalizationService;
    private CustomizationPluginMgr pluginMgr;
    private Map<String, String> avatarMap = new ConcurrentHashMap();
    private Map<String, String> binaryMap = new ConcurrentHashMap();
    public static Map<String, Map<String, BinaryDelegation>> delegations = new ConcurrentHashMap();
    private Map<String, INuxeoPlayerModule> players = new ConcurrentHashMap();
    private List<TaskbarTask> tasks;
    private Map<String, PanelPlayer> navigationPanelPlayers;
    protected final ICustomizationService customizationService;

    public DefaultCMSCustomizer(PortletContext ctx) {
        this.portletCtx = ctx;
        this.portalUrlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        IInternationalizationService internationalizationService = (IInternationalizationService)this.portletCtx.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.customizationService = (ICustomizationService)Locator.findMBean(ICustomizationService.class, (String)"osivia:service=CustomizationService");
        this.players = new Hashtable();
        this.players.put("defaultPlayer", new DefaultPlayer());
        this.pluginMgr = new CustomizationPluginMgr(this);
        try {
            this.cl = Thread.currentThread().getContextClassLoader();
            this.parser = WysiwygParser.getInstance().getParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IWebIdService getWebIdService() {
        if (this.webIdService == null) {
            this.webIdService = (IWebIdService)this.portletCtx.getAttribute("webIdService");
        }
        return this.webIdService;
    }

    public IWebUrlService getWebUrlService() {
        if (this.webUrlService == null) {
            this.webUrlService = (IWebUrlService)Locator.findMBean(IWebUrlService.class, (String)"osivia:service=webUrlService");
        }
        return this.webUrlService;
    }

    public NuxeoConnectionProperties getNuxeoConnectionProps() {
        if (this.nuxeoConnection == null) {
            this.nuxeoConnection = new NuxeoConnectionProperties();
        }
        return this.nuxeoConnection;
    }

    public UserPagesLoader getUserPagesLoader() {
        if (this.userPagesLoader == null) {
            this.userPagesLoader = new UserPagesLoader(this.portletCtx, this, this.cmsService);
        }
        return this.userPagesLoader;
    }

    public MenuBarFormater getMenuBarFormater() {
        if (this.menuBarFormater == null) {
            this.menuBarFormater = new MenuBarFormater(this.portletCtx, this, this.cmsService);
        }
        return this.menuBarFormater;
    }

    @Deprecated
    public NavigationItemAdapter getNavigationItemAdapter() {
        if (this.navigationItemAdapter == null) {
            this.navigationItemAdapter = new NavigationItemAdapter(this.portletCtx, this, this.cmsService);
        }
        return this.navigationItemAdapter;
    }

    public final Map<String, EditableWindow> getEditableWindows(Locale locale) {
        return this.pluginMgr.customizeEditableWindows(locale);
    }

    public Map<String, EditableWindow> initEditableWindows(Locale locale) {
        HashMap<String, EditableWindow> map = new HashMap<String, EditableWindow>();
        map.put("fgt.html", (EditableWindow)new HTMLEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "html_Frag_"));
        map.put("fgt.list", (EditableWindow)new ListEditableWindow("toutatice-portail-cms-nuxeo-viewListPortletInstance", "liste_Frag_"));
        map.put("fgt.picture", (EditableWindow)new PictureEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "picture_Frag_"));
        map.put("fgt.portlet", (EditableWindow)new PortletEditableWindow("", "portlet_Frag_"));
        map.put("ew.fragment", (EditableWindow)new FragmentEditableWindow("toutatice-portail-cms-nuxeo-viewFragmentPortletInstance", "ew_frag_"));
        return map;
    }

    public BrowserAdapter getBrowserAdapter() {
        return BrowserAdapter.getInstance((CMSService)this.cmsService);
    }

    public CustomizationPluginMgr getPluginMgr() {
        return this.pluginMgr;
    }

    public INuxeoCommentsService getNuxeoCommentsService() {
        if (this.commentsService == null) {
            this.commentsService = new NuxeoCommentsServiceImpl(this.cmsService, this.directoryService);
        }
        return this.commentsService;
    }

    public final List<ListTemplate> getListTemplates(Locale locale) {
        return this.pluginMgr.customizeListTemplates(locale);
    }

    public List<ListTemplate> initListTemplates(Locale locale) {
        ArrayList<ListTemplate> templates = new ArrayList<ListTemplate>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.add(new ListTemplate("mini", bundle.getString("LIST_TEMPLATE_MINI"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("normal", bundle.getString("LIST_TEMPLATE_NORMAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("detailed", bundle.getString("LIST_TEMPLATE_DETAILED"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("editorial", bundle.getString("LIST_TEMPLATE_EDITORIAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate("contextual-links", bundle.getString("LIST_TEMPLATE_CONTEXTUAL_LINKS"), DEFAULT_SCHEMAS));
        return templates;
    }

    public final Map<String, FragmentType> getFragmentTypes(Locale locale) {
        return this.pluginMgr.getFragments(locale);
    }

    public List<FragmentType> initListFragments(Locale locale) {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        PortletContext portletContext = this.getPortletCtx();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        fragmentTypes.add(new FragmentType("text_property", bundle.getString("FRAGMENT_TYPE_TEXT"), (IFragmentModule)new PropertyFragmentModule(portletContext, false)));
        fragmentTypes.add(new FragmentType("html_property", bundle.getString("FRAGMENT_TYPE_HTML"), (IFragmentModule)new PropertyFragmentModule(portletContext, true)));
        fragmentTypes.add(new FragmentType("navigation_picture", bundle.getString("FRAGMENT_TYPE_NAVIGATION_PICTURE"), (IFragmentModule)new NavigationPictureFragmentModule(portletContext)));
        fragmentTypes.add(new FragmentType("document_picture", bundle.getString("FRAGMENT_TYPE_DOCUMENT_PICTURE"), (IFragmentModule)new DocumentPictureFragmentModule(portletContext)));
        fragmentTypes.add(new FragmentType("doc_link", bundle.getString("FRAGMENT_TYPE_LINK"), (IFragmentModule)new LinkFragmentModule(portletContext)));
        fragmentTypes.add(new FragmentType("space_menubar", bundle.getString("FRAGMENT_TYPE_MENUBAR"), (IFragmentModule)new SpaceMenubarFragmentModule(portletContext)));
        fragmentTypes.add(new FragmentType("site_picture", bundle.getString("FRAGMENT_TYPE_SITE_PICTURE"), (IFragmentModule)new SitePictureFragmentModule(portletContext)));
        return fragmentTypes;
    }

    public SortedMap<String, String> getMenuTemplates(Locale locale) {
        return this.pluginMgr.customizeMenuTemplates(locale);
    }

    public SortedMap<String, String> initMenuTemplates(Locale locale) {
        SortedMap<String, String> templates = Collections.synchronizedSortedMap(new TreeMap());
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.put("", bundle.getString("MENU_TEMPLATE_DEFAULT"));
        templates.put("horizontal", bundle.getString("MENU_TEMPLATE_HORIZONTAL"));
        templates.put("footer", bundle.getString("MENU_TEMPLATE_FOOTER"));
        templates.put("fancytree-lazy", bundle.getString("MENU_TEMPLATE_FANCYTREE_LAZY"));
        templates.put("fancytree-filter", bundle.getString("MENU_TEMPLATE_FANCYTREE_FILTER"));
        return templates;
    }

    public static String getSearchSchema() {
        return "dublincore,common,file,toutatice";
    }

    public Player getCMSDefaultPlayer(CMSServiceCtx ctx) throws PortletException {
        Document doc = (Document)ctx.getDoc();
        NuxeoDocumentContext docCtx = NuxeoController.getDocumentContext((CMSServiceCtx)ctx, (String)doc.getPath());
        return this.getCMSDefaultPlayer((DocumentContext)docCtx);
    }

    public Player getCMSDefaultPlayer(DocumentContext<Document> docCtx) {
        return ((INuxeoPlayerModule)this.players.get("defaultPlayer")).getCMSPlayer(docCtx);
    }

    public Player getCMSOrderedFolderPlayer(DocumentContext<Document> docCtx) throws CMSException {
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        Document doc = (Document)docCtx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(docCtx, (boolean)true));
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", navigationInfos.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player getCMSFileBrowser(DocumentContext<Document> docCtx) {
        Document document = (Document)docCtx.getDoc();
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance");
        return linkProps;
    }

    public Player getCMSFolderPlayer(DocumentContext<Document> docCtx) throws CMSException {
        Document doc = (Document)docCtx.getDoc();
        BasicPublicationInfos navigationInfos = (BasicPublicationInfos)docCtx.getPublicationInfos(BasicPublicationInfos.class);
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", NuxeoController.createFolderRequest(docCtx, (boolean)false));
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", navigationInfos.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", navigationInfos.getState().toString());
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player getCMSSectionPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", "ecm:path STARTSWITH '" + doc.getPath() + "' AND ecm:mixinType != 'Folderish' ORDER BY dc:modified DESC");
        windowProperties.put("osivia.cms.style", "editorial");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public Player createPortletLink(CMSServiceCtx ctx, String portletInstance, String uid) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", uid);
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        Player linkProps = new Player();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance(portletInstance);
        return linkProps;
    }

    public Player getCMSPlayer(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsContext, document.getPath());
        boolean workspace = cmsContext.getContextualizationBasePath() != null && pubInfos.isLiveSpace();
        List modules = this.pluginMgr.customizeModules();
        NuxeoDocumentContext docCtx = NuxeoController.getDocumentContext((CMSServiceCtx)cmsContext, (String)document.getPath());
        for (INuxeoPlayerModule module : modules) {
            Player player = module.getCMSPlayer((DocumentContext)docCtx);
            if (player == null) continue;
            return player;
        }
        if ("UserWorkspace".equals(document.getType())) {
            cmsContext.setDisplayLiveVersion("1");
            return this.getCMSFileBrowser((DocumentContext)docCtx);
        }
        if ("Folder".equals(document.getType()) || "OrderedFolder".equals(document.getType()) || "Section".equals(document.getType())) {
            if (workspace) {
                cmsContext.setDisplayLiveVersion("1");
                Player props = this.getCMSFileBrowser((DocumentContext)docCtx);
                props.getWindowProperties().put("osivia.title", document.getTitle());
                return props;
            }
            if ("Folder".equals(document.getType())) {
                return this.getCMSFolderPlayer((DocumentContext)docCtx);
            }
            return this.getCMSOrderedFolderPlayer((DocumentContext)docCtx);
        }
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)cmsContext);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.CMS_PLAYER);
            Documents configs = null;
            try {
                configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)cmsContext, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configs != null && configs.size() > 0) {
                for (Document config : configs) {
                    String documentType = config.getProperties().getString("wconf:code");
                    String playerInstance = config.getProperties().getString("wconf:code2");
                    if (!document.getType().equals(documentType) || !this.players.containsKey(playerInstance)) continue;
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    PropertyList list = config.getProperties().getList("wconf:options");
                    for (Object o : list.list()) {
                        if (!(o instanceof PropertyMap)) continue;
                        PropertyMap map = (PropertyMap)o;
                        windowProperties.put(map.get("propertyName").toString(), map.get("propertyDefaultValue").toString());
                    }
                    return ((INuxeoPlayerModule)this.players.get(playerInstance)).getCMSPlayer((DocumentContext)docCtx);
                }
            }
        }
        return ((INuxeoPlayerModule)this.players.get("defaultPlayer")).getCMSPlayer((DocumentContext)docCtx);
    }

    public String getDefaultExternalViewer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        this.getNuxeoConnectionProps();
        String externalUrl = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents";
        return externalUrl;
    }

    public String createPortletDelegatedExternalLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId());
        resourceURL.setParameter("type", "link");
        return resourceURL.toString();
    }

    public String createPortletDelegatedFileContentLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId() + "/file:content");
        resourceURL.setParameter("type", "file");
        resourceURL.setParameter("docPath", doc.getPath());
        resourceURL.setParameter("fieldName", "file:content");
        resourceURL.setCacheability("cacheLevelPage");
        return resourceURL.toString();
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        if ("file-browser-menu-workspace".equals(ctx.getDisplayContext())) {
            return this.getDefaultExternalViewer(ctx);
        }
        return null;
    }

    public Link createCustomLink(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        String displayContext = cmsContext.getDisplayContext();
        String url = null;
        boolean externalLink = false;
        boolean downloadable = false;
        if (!"detailedView".equals(displayContext)) {
            PropertyMap attachedFileProperties;
            if (("File".equals(document.getType()) || "Audio".equals(document.getType()) || "Video".equals(document.getType())) && TEMPLATE_DOWNLOAD.equals(displayContext) && (attachedFileProperties = document.getProperties().getMap("file:content")) != null && !attachedFileProperties.isEmpty()) {
                NuxeoController nuxeoCtl = new NuxeoController(cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse(), cmsContext.getPortletCtx());
                nuxeoCtl.setCurrentDoc(document);
                url = nuxeoCtl.createFileLink(document, "file:content");
                downloadable = true;
            }
            if ("ContextualLink".equals(document.getType()) && !"document".equals(displayContext) && !"fileExplorer".equals(displayContext)) {
                url = this.createPortletDelegatedExternalLink(cmsContext);
                externalLink = true;
            }
            if (url == null) {
                url = this.getNuxeoNativeViewerUrl(cmsContext);
                externalLink = true;
            }
        }
        if (url != null) {
            Link link = new Link(url, externalLink);
            link.setDownloadable(downloadable);
            return link;
        }
        return null;
    }

    public void formatContentMenuBar(CMSServiceCtx ctx) throws Exception {
        CMSPublicationInfos publicationInfos = null;
        CMSExtendedDocumentInfos extendedDocumentInfos = null;
        if (ctx.getDoc() != null) {
            Document doc = (Document)ctx.getDoc();
            publicationInfos = this.cmsService.getPublicationInfos(ctx, doc.getPath());
            extendedDocumentInfos = this.cmsService.getExtendedDocumentInfos(ctx, doc.getPath());
        }
        this.getMenuBarFormater().formatContentMenuBar(ctx, publicationInfos, extendedDocumentInfos);
        List menuBar = (List)ctx.getRequest().getAttribute("osivia.menuBar");
        List customizeMenubars = this.pluginMgr.customizeMenubars(ctx.getRequest().getLocale());
        for (IMenubarModule menubarCustom : customizeMenubars) {
            menubarCustom.adaptContentMenuBar(ctx, menuBar, publicationInfos, extendedDocumentInfos);
        }
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        return this.getUserPagesLoader().computeUserPreloadedPages(cmsCtx);
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        return null;
    }

    public String addPublicationFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        String requestFilter = "";
        requestFilter = "1".equals(ctx.getDisplayLiveVersion()) ? "ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0  AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState <> 'deleted'" : ("2".equals(ctx.getDisplayLiveVersion()) ? " ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0 AND ecm:mixinType <> 'isLocalPublishLive'" : "ecm:isProxy = 1 AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted' AND ecm:isCheckedInVersion = 0");
        return this.addExtraNxQueryFilters(ctx, nuxeoRequest, requestFilteringPolicy, requestFilter);
    }

    protected String addExtraNxQueryFilters(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy, String requestFilter) throws Exception {
        String policyFilter = null;
        ServerInvocation invocation = ctx.getServerInvocation();
        String portalName = null;
        if (invocation != null) {
            portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        }
        if (portalName != null) {
            String extraFilter;
            PortalObjectContainer portalObjectContainer = (PortalObjectContainer)invocation.getAttribute(Scope.REQUEST_SCOPE, (Object)"osivia.portalObjectContainer");
            PortalObject po = portalObjectContainer.getObject(PortalObjectId.parse((String)"", (String)("/" + portalName), (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT));
            if (requestFilteringPolicy != null) {
                policyFilter = requestFilteringPolicy;
            } else {
                String sitePolicy = po.getProperty("osivia.cms.requestFilteringPolicy");
                if (sitePolicy != null) {
                    if ("local".equals(sitePolicy)) {
                        policyFilter = "local";
                    }
                } else {
                    String portalType = po.getProperty("osivia.portal.portalType");
                    if ("space".equals(portalType)) {
                        policyFilter = "local";
                    }
                }
            }
            if ("local".equals(policyFilter)) {
                String pathFilter = "";
                for (PortalObject child : ((Portal)po).getChildren(4)) {
                    String cmsPath = child.getDeclaredProperty("osivia.cms.basePath");
                    if (cmsPath == null || cmsPath.length() <= 0) continue;
                    if (pathFilter.length() > 0) {
                        pathFilter = pathFilter + " OR ";
                    }
                    pathFilter = pathFilter + "ecm:path STARTSWITH '" + cmsPath + "'";
                }
                if (pathFilter.length() > 0) {
                    requestFilter = requestFilter + " AND (" + pathFilter + ")";
                }
            }
            if ((extraFilter = this.getExtraRequestFilter(ctx, requestFilteringPolicy)) != null) {
                requestFilter = requestFilter + " OR (" + extraFilter + ")";
            }
        }
        String beforeOrderBy = "";
        String orderBy = "";
        String editedNuxeoRequest = nuxeoRequest;
        try {
            Pattern ressourceExp = Pattern.compile("(.*)ORDER([ ]*)BY(.*)");
            Matcher m = ressourceExp.matcher(editedNuxeoRequest.toUpperCase());
            m.matches();
            if (m.groupCount() == 3) {
                beforeOrderBy = editedNuxeoRequest.substring(0, m.group(1).length());
                orderBy = editedNuxeoRequest.substring(m.group(1).length());
            }
        }
        catch (IllegalStateException e) {
            beforeOrderBy = editedNuxeoRequest;
        }
        String finalRequest = beforeOrderBy;
        if (finalRequest.length() > 0) {
            finalRequest = finalRequest + " AND ";
        }
        finalRequest = finalRequest + "(" + requestFilter + ") ";
        editedNuxeoRequest = finalRequest = finalRequest + " " + orderBy;
        return editedNuxeoRequest;
    }

    public String addSearchFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        StringBuffer filter = new StringBuffer(2);
        filter.append(" ecm:mixinType <> 'HiddenInNavigation' AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0");
        filter.append(" AND ecm:mixinType <> 'isLocalPublishLive'");
        return this.addExtraNxQueryFilters(ctx, nuxeoRequest, requestFilteringPolicy, filter.toString());
    }

    public String getExtraRequestFilter(CMSServiceCtx ctx, String requestFilteringPolicy) throws Exception {
        String extraRequetFilter = null;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.EXTRA_REQUEST_FILTER);
            Documents configs = null;
            configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            if (configs.size() > 0) {
                extraRequetFilter = "";
                int i = 0;
                for (Document config : configs) {
                    String nxqlCode = config.getProperties().getString("wconf:code");
                    if (nxqlCode == null) continue;
                    if (i > 0) {
                        extraRequetFilter = extraRequetFilter.concat("OR");
                    }
                    extraRequetFilter = extraRequetFilter.concat(" ").concat(nxqlCode);
                    ++i;
                }
            }
        }
        return extraRequetFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformHTMLContent(CMSServiceCtx ctx, String htmlContent) throws Exception {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Transformer transformer = WysiwygParser.getInstance().getTemplate().newTransformer();
            transformer.setParameter("bridge", new XSLFunctions((INuxeoCustomizer)this, ctx));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XMLReader parser = WysiwygParser.getInstance().getParser();
            transformer.transform(new SAXSource(parser, new InputSource(new StringReader(htmlContent))), new StreamResult(output));
            String string = ((Object)output).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public String transformLink(CMSServiceCtx ctx, String link) {
        XSLFunctions xslFunctions = new XSLFunctions((INuxeoCustomizer)this, ctx);
        return xslFunctions.link(NuxeoConnectionProperties.getPublicDomainUri().toString() + link);
    }

    public Link getLinkFromNuxeoURL(CMSServiceCtx cmsContext, String url) {
        Link link;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/")) {
            Page page;
            Window window;
            String nuxeoURL = StringUtils.substringBefore((String)url, (String)"#");
            String anchor = StringUtils.substringAfter((String)url, (String)"#");
            String cmsPath = this.transformNuxeoURL(cmsContext, nuxeoURL);
            HashMap parameters = new HashMap(0);
            String currentPagePath = null;
            if (cmsContext.getRequest() != null && (window = (Window)cmsContext.getRequest().getAttribute("osivia.window")) != null && (page = window.getPage()) != null) {
                currentPagePath = page.getId().toString(PortalObjectPath.CANONICAL_FORMAT);
            }
            String portalURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, currentPagePath, cmsPath, parameters, null, null, null, null, null, null);
            if (StringUtils.isNotBlank((String)anchor)) {
                portalURL = portalURL + "#" + anchor;
            }
            link = new Link(portalURL, false);
        } else if (StringUtils.isBlank((String)url)) {
            link = new Link("#", false);
        } else {
            boolean external;
            StringBuilder builder = new StringBuilder();
            if (!StringUtils.startsWithIgnoreCase((String)url, (String)"http://") && !StringUtils.startsWithIgnoreCase((String)url, (String)"https://")) {
                builder.append("http://");
            }
            builder.append(url);
            String absoluteURL = builder.toString();
            try {
                URL urlObject = new URL(absoluteURL);
                String serverName = cmsContext.getRequest().getServerName();
                external = !StringUtils.equals((String)urlObject.getHost(), (String)serverName);
            }
            catch (Exception e) {
                external = false;
            }
            link = new Link(absoluteURL, external);
        }
        return link;
    }

    private String transformNuxeoURL(CMSServiceCtx cmsContext, String url) {
        String cmsPath = null;
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/web/")) {
            String webId = StringUtils.removeStart((String)url, (String)"/nuxeo/web/");
            if (webId.contains("/")) {
                webId = StringUtils.substringAfterLast((String)webId, (String)"/");
            }
            if (webId.contains(".")) {
                webId = StringUtils.substringBefore((String)webId, (String)".");
            }
            cmsPath = this.getWebIdService().webIdToCmsPath(webId);
        } else if (StringUtils.startsWith((String)url, (String)"/nuxeo/nxpath/")) {
            cmsPath = StringUtils.removeStart((String)url, (String)"/nuxeo/nxpath/");
            cmsPath = "/" + StringUtils.substringAfter((String)cmsPath, (String)"/");
        }
        if (cmsPath == null) {
            LOGGER.warn((Object)("Invalid Nuxeo URL: '" + url + "'."));
        }
        return cmsPath;
    }

    public Map<String, DocumentType> getCMSItemTypes() {
        return this.pluginMgr.customizeCMSItemTypes();
    }

    protected List<DocumentType> getCustomizedCMSItemTypes() {
        return new ArrayList<DocumentType>();
    }

    public List<DocumentType> getDefaultCMSItemTypes() {
        ArrayList<DocumentType> defaultTypes = new ArrayList<DocumentType>();
        defaultTypes.add(new DocumentType("Workspace", true, false, false, true, false, false, new ArrayList(0), "/default/templates/workspace", "glyphicons glyphicons-wallet", true));
        defaultTypes.add(new DocumentType("PortalSite", true, false, false, true, true, true, Arrays.asList("File", "PortalPage", "ContextualLink"), null, "glyphicons glyphicons-global", true));
        defaultTypes.add(new DocumentType("PortalPage", true, true, true, true, true, true, Arrays.asList("File", "PortalPage", "ContextualLink"), null, "glyphicons glyphicons-more-items"));
        defaultTypes.add(new DocumentType("Folder", true, true, true, false, false, true, Arrays.asList("File", "Folder", "Note"), null, "glyphicons glyphicons-folder-closed"));
        defaultTypes.add(new DocumentType("OrderedFolder", true, true, true, true, false, true, Arrays.asList("File", "Folder", "Note"), null, "glyphicons glyphicons-folder-closed"));
        defaultTypes.add(new DocumentType("File", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-file", false, true, true));
        defaultTypes.add(new DocumentType("Note", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-notes-2"));
        defaultTypes.add(new DocumentType("ContextualLink", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-link"));
        return defaultTypes;
    }

    public String getCommentsHTMLContent(CMSServiceCtx cmsContext, Document document) throws CMSException {
        List comments = this.getNuxeoCommentsService().getDocumentComments(cmsContext, document);
        CommentsFormatter formatter = new CommentsFormatter(comments);
        Locale locale = cmsContext.getRequest().getLocale();
        return formatter.generateHTMLContent(locale);
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public void setCmsService(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public IDirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(IDirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public INotificationsService getNotificationsService() {
        return this.notificationsService;
    }

    public void setNotificationsService(INotificationsService notificationsService) {
        this.notificationsService = notificationsService;
    }

    public IInternationalizationService getInternationalizationService() {
        return this.internationalizationService;
    }

    public void setInternationalizationService(IInternationalizationService internationalizationService) {
        this.internationalizationService = internationalizationService;
    }

    public PortletContext getPortletCtx() {
        return this.portletCtx;
    }

    @Deprecated
    public void setNavigationItemAdapter(NavigationItemAdapter navigationItemAdapter) {
        this.navigationItemAdapter = navigationItemAdapter;
    }

    public XMLReader getParser() {
        return this.parser;
    }

    public void setParser(XMLReader parser) {
        this.parser = parser;
    }

    public String getContentWebIdPath(CMSServiceCtx cmsCtx) {
        return this.getContentWebIdPath(cmsCtx, null);
    }

    public String getContentWebIdPath(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        Document doc = (Document)cmsCtx.getDoc();
        String webId = doc.getString("ttc:webid");
        String permLinkPath = ((Document)cmsCtx.getDoc()).getPath();
        boolean isRemoteProxy = false;
        isRemoteProxy = pubInfos == null ? ContextDocumentsHelper.isRemoteProxy((Document)doc) : DocumentHelper.isRemoteProxy((CMSServiceCtx)cmsCtx, (CMSPublicationInfos)pubInfos);
        if (StringUtils.isNotEmpty((String)webId) && !isRemoteProxy) {
            String explicitUrl = doc.getString("ttc:explicitUrl");
            String extension = doc.getString("ttc:extensionUrl");
            HashMap<String, String> properties = new HashMap<String, String>();
            if (explicitUrl != null) {
                properties.put("explicitUrl", explicitUrl);
            }
            if (extension != null) {
                properties.put("extensionUrl", extension);
            }
            permLinkPath = this.getWebIdService().webIdToCmsPath(webId);
        }
        return permLinkPath;
    }

    public Link getUserAvatar(CMSServiceCtx cmsCtx, String username) throws CMSException {
        String src = "";
        try {
            String avatarTime = (String)this.avatarMap.get(username);
            if (avatarTime == null) {
                avatarTime = this.refreshUserAvatar(cmsCtx, username);
            }
            src = AVATAR_SERVLET.concat(URLEncoder.encode(username, "UTF-8")).concat("&t=").concat(avatarTime.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new CMSException((Throwable)e);
        }
        return new Link(src, false);
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        String avatarTime = Long.toString(new Date().getTime());
        this.avatarMap.put(username, avatarTime);
        return avatarTime;
    }

    public boolean isPathInLiveState(CMSServiceCtx cmsCtx, Document doc) {
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            return true;
        }
        return doc.getPath().equals(cmsCtx.getForcedLivePath());
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        String id = cmsCtx.getServletRequest().getSession().getId();
        Map delegationMap = (Map)delegations.get(id);
        if (delegationMap != null) {
            return (BinaryDelegation)delegationMap.get(path);
        }
        return null;
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws CMSException {
        String src = "";
        String path = "";
        boolean liveState = false;
        BinaryDelegation delegation = new BinaryDelegation();
        try {
            String binaryTimeStamp;
            String portalName = null;
            ServerInvocation invocation = cmsCtx.getServerInvocation();
            Boolean isAdmin = false;
            if (invocation != null) {
                portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
                isAdmin = (Boolean)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"osivia.isAdmin");
            }
            if (binary.getDocument() != null) {
                Document doc = (Document)binary.getDocument();
                path = doc.getPath();
                liveState = this.isPathInLiveState(cmsCtx, doc);
                delegation.setGrantedAccess(true);
            } else {
                path = binary.getPath();
            }
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            delegation.setSubject(subject);
            delegation.setAdmin(isAdmin.booleanValue());
            if (StringUtils.endsWith((String)path, (String)".proxy") && !StringUtils.endsWith((String)path, (String)".remote.proxy")) {
                path = StringUtils.removeEnd((String)path, (String)".proxy");
            }
            delegation.setUserName(cmsCtx.getServletRequest().getRemoteUser());
            Map delegationMap = this.getUserDelegation(cmsCtx);
            delegationMap.put(path, delegation);
            boolean refresh = PageProperties.getProperties().isRefreshingPage();
            String fileName = binary.getFileName();
            if (fileName == null) {
                if (binary.getDocument() != null) {
                    Document document = (Document)binary.getDocument();
                    PropertyMap fileMap = document.getProperties().getMap("file:content");
                    if (fileMap != null) {
                        fileName = fileMap.getString("name");
                    }
                } else if (binary.getIndex() != null && cmsCtx.getDoc() != null) {
                    PropertyMap fileMap;
                    int index = NumberUtils.toInt((String)binary.getIndex());
                    Document document = (Document)cmsCtx.getDoc();
                    PropertyList files = document.getProperties().getList("files:files");
                    if (files != null && files.size() > index && (fileMap = files.getMap(index)) != null) {
                        fileName = fileMap.getString("filename");
                    }
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(BINARY_SERVLET);
            if (StringUtils.isNotBlank((String)fileName)) {
                sb.append("/").append(fileName);
            }
            sb.append("?type=").append(binary.getType().name()).append("&path=").append(URLEncoder.encode(path, "UTF-8"));
            if (portalName != null) {
                sb.append("&portalName=").append(portalName);
            }
            if (binary.getIndex() != null) {
                sb.append("&index=").append(binary.getIndex());
            }
            if (liveState) {
                sb.append("&liveState=").append(liveState);
            }
            if (binary.getContent() != null) {
                sb.append("&content=").append(binary.getContent());
            }
            if (binary.getFieldName() != null) {
                sb.append("&fieldName=").append(binary.getFieldName());
            }
            if (binary.getFileName() != null) {
                sb.append("&fileName=").append(URLEncoder.encode(binary.getFileName(), "UTF-8"));
            }
            if (refresh) {
                sb.append("&refresh=").append(refresh);
            }
            if (cmsCtx.getScope() != null) {
                sb.append("&scope=").append(cmsCtx.getScope());
            }
            if (cmsCtx.getForcePublicationInfosScope() != null) {
                sb.append("&fscope=").append(cmsCtx.getForcePublicationInfosScope());
            }
            if ((binaryTimeStamp = (String)this.binaryMap.get(path)) == null) {
                binaryTimeStamp = this.refreshBinaryResource(cmsCtx, path);
            }
            sb.append("&t=");
            sb.append(binaryTimeStamp.toString());
            src = sb.toString();
        }
        catch (Exception e) {
            new CMSException((Throwable)e);
        }
        return new Link(src, false);
    }

    private Map<String, BinaryDelegation> getUserDelegation(CMSServiceCtx cmsCtx) {
        String id = cmsCtx.getServletRequest().getSession().getId();
        ConcurrentHashMap delegationMap = (ConcurrentHashMap)delegations.get(id);
        if (delegationMap == null) {
            delegationMap = new ConcurrentHashMap();
            delegations.put(id, delegationMap);
        }
        return delegationMap;
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        delegations.remove(sessionEvent.getSession().getId());
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public String refreshBinaryResource(CMSServiceCtx cmsCtx, String path) {
        String pathTime = Long.toString(new Date().getTime());
        this.binaryMap.put(path, pathTime);
        return pathTime;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsContext, INuxeoCommand command) throws CMSException {
        try {
            return this.cmsService.executeNuxeoCommand(cmsContext, command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Map<String, EcmCommand> getEcmCommands() {
        ConcurrentHashMap<String, EcmCommand> commands = new ConcurrentHashMap<String, EcmCommand>();
        commands.put(EcmCommonCommands.lock.name(), (EcmCommand)new LockCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.unlock.name(), (EcmCommand)new UnlockCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.subscribe.name(), (EcmCommand)new SubscribeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.unsubscribe.name(), (EcmCommand)new UnsubscribeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.synchronizeFolder.name(), (EcmCommand)new SynchronizeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.unsynchronizeFolder.name(), (EcmCommand)new UnsynchronizeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.eraseModifications.name(), (EcmCommand)new EraseModificationsCommand(this.getNotificationsService(), this.getInternationalizationService()));
        return commands;
    }

    public List<TaskbarTask> getTaskbarTasks() {
        if (this.tasks == null) {
            this.tasks = new ArrayList();
            this.tasks.add(this.getHomeTask());
            this.tasks.add(this.getSearchTask());
        }
        return this.tasks;
    }

    protected TaskbarTask getHomeTask() {
        TaskbarTask task = new TaskbarTask();
        task.setId("HOME");
        task.setKey("HOME");
        task.setIcon("glyphicons glyphicons-home");
        return task;
    }

    protected TaskbarTask getSearchTask() {
        TaskbarTask task = new TaskbarTask();
        task.setId("SEARCH");
        task.setKey("SEARCH_TASK");
        task.setIcon("glyphicons glyphicons-search");
        PanelPlayer maximizedPlayer = new PanelPlayer();
        maximizedPlayer.setInstance("toutatice-portail-cms-nuxeo-searchPortletInstance");
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("osivia.cms.uri", "${basePath}");
        maximizedPlayer.setProperties(properties);
        task.setMaximizedPlayer(maximizedPlayer);
        return task;
    }

    public Map<String, PanelPlayer> getNavigationPanelPlayers() {
        if (this.navigationPanelPlayers == null) {
            this.navigationPanelPlayers = new ConcurrentHashMap();
            this.navigationPanelPlayers.put("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance", this.getFileBrowserPanelPlayer());
        }
        return this.navigationPanelPlayers;
    }

    protected PanelPlayer getFileBrowserPanelPlayer() {
        PanelPlayer player = new PanelPlayer();
        player.setInstance("toutatice-portail-cms-nuxeo-publishMenuPortletInstance");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("osivia.bootstrapPanelStyle", String.valueOf(true));
        properties.put("osivia.cms.template", "fancytree-lazy");
        properties.put("osivia.cms.startLevel", String.valueOf(2));
        properties.put("osivia.cms.forceNavigation", String.valueOf(true));
        player.setProperties(properties);
        return player;
    }

    public String getJSPName(String name, PortletContext portletContext, PortletRequest request) throws CMSException {
        try {
            CustomizedJsp customizedPage = this.pluginMgr.customizeJSP(name, portletContext, request);
            String customizedName = customizedPage != null ? customizedPage.getName() : null;
            return customizedName;
        }
        catch (IOException e) {
            throw new CMSException((Throwable)e);
        }
    }
}

